/*
 * Decompiled with CFR 0.152.
 */
package com.zjw.video.open.api.sdk.utils;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;

public class LocalHostUtil {
    private static String localHost = null;

    public static void setLocalHost(String host) {
        localHost = host;
    }

    public static String getLocalHost() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)localHost)) {
            return localHost;
        }
        localHost = LocalHostUtil.findLocalHost();
        return localHost;
    }

    private static String findLocalHost() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        InetAddress ipv6Address = null;
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> en = networkInterface.getInetAddresses();
            while (en.hasMoreElements()) {
                InetAddress address = en.nextElement();
                if (address.isLoopbackAddress()) continue;
                if (!(address instanceof Inet6Address)) {
                    return LocalHostUtil.normalizeHostAddress(address);
                }
                ipv6Address = address;
            }
        }
        if (ipv6Address != null) {
            return LocalHostUtil.normalizeHostAddress(ipv6Address);
        }
        InetAddress localHost = InetAddress.getLocalHost();
        return LocalHostUtil.normalizeHostAddress(localHost);
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        return localHost instanceof Inet6Address ? localHost.getHostAddress() : localHost.getHostAddress();
    }

    public static String getLastSegment() {
        try {
            String lastSegIP = LocalHostUtil.getLocalHost();
            return lastSegIP.substring(lastSegIP.lastIndexOf(".") + 1);
        }
        catch (Exception var1) {
            return String.valueOf(System.currentTimeMillis() % 604800000L);
        }
    }
}

