/*
 * Decompiled with CFR 0.152.
 */
package com.zjw.video.open.api.sdk.utils;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;

public class JwtUtil {
    public static String createAppToken(String appId, String appKey, String uid, String encodeKeys) {
        byte[] decodedKey = Base64.getDecoder().decode(encodeKeys);
        SecretKeySpec key = new SecretKeySpec(decodedKey, SignatureAlgorithm.HS256.getJcaName());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        ((Calendar)calendar).add(12, 30);
        String token = Jwts.builder().setSubject(UUID.randomUUID().toString()).claim("appid", (Object)appId).claim("appkey", (Object)appKey).claim("uid", (Object)uid).claim("time", (Object)System.currentTimeMillis()).setExpiration(calendar.getTime()).signWith(SignatureAlgorithm.HS256, (Key)key).compact();
        return token;
    }

    public static String createAppTokenJson(String json, String encodeKeys) {
        byte[] decodedKey = Base64.getDecoder().decode(encodeKeys);
        SecretKeySpec key = new SecretKeySpec(decodedKey, SignatureAlgorithm.HS256.getJcaName());
        String token = Jwts.builder().setPayload(json).signWith(SignatureAlgorithm.HS256, (Key)key).compact();
        return token;
    }

    public static void main(String[] args) {
        String appToken = JwtUtil.createAppToken("test123456", "psw123456", "1", "trainZjwVideoApi");
        System.out.println(appToken);
        String json = "{\"appid\":\"test123456\",\"appkey\":\"psw123456\",\"uid\":\"1\",\"time\":\"1682558555000\",\"subject\":\"689d6a7d-257b-4210-a25b-9f234a741da4\",\"expiration\":\"1682561092108\"}";
        String appTokenJson = JwtUtil.createAppTokenJson(json, "trainZjwVideoApi");
        System.out.println(appTokenJson);
    }
}

