/*
 * Decompiled with CFR 0.152.
 */
package com.zjw.video.open.api.sdk.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;

public class HttpUtil {
    public static final String URL_SPLIT_PARAM = "&";

    public static String sendPost(String url, String reqBody) {
        return HttpUtil.sendPost(url, reqBody, 15000, 30000);
    }

    public static String sendPost(String url, String reqBody, Map<String, String> headerMap) {
        return HttpUtil.sendPost(url, reqBody, 15000, 30000, headerMap);
    }

    public static String sendPost(String url, String reqBody, String charset) {
        return HttpUtil.sendPost(url, reqBody, 15000, 30000, charset, null);
    }

    public static String sendPost(String url, String reqBody, int connectTimeOut, int soTimeOut) {
        return HttpUtil.sendPost(url, reqBody, connectTimeOut, soTimeOut, "UTF-8", null);
    }

    public static String sendPost(String url, String reqBody, int connectTimeOut, int soTimeOut, Map<String, String> headerMap) {
        return HttpUtil.sendPost(url, reqBody, connectTimeOut, soTimeOut, "UTF-8", headerMap);
    }

    public static String sendPost(String url, String reqBody, int connectTimeOut, int soTimeOut, String charset, Map<String, String> headerMap) {
        HttpClient client = new HttpClient();
        String respBody = null;
        try {
            System.out.println("\u53d1\u9001POST\u62a5\u6587:" + reqBody);
            PostMethod method = new PostMethod(url);
            if (headerMap != null && headerMap.size() > 0) {
                headerMap.forEach((key, value) -> method.addRequestHeader(key, value));
            }
            method.setRequestEntity((RequestEntity)new StringRequestEntity(reqBody, "application/json", charset));
            client.getHttpConnectionManager().getParams().setConnectionTimeout(connectTimeOut);
            client.getHttpConnectionManager().getParams().setSoTimeout(soTimeOut);
            int respCode = client.executeMethod((HttpMethod)method);
            System.out.println("\u5e94\u7b54\u72b6\u6001\u7801:" + respCode);
            InputStream in = method.getResponseBodyAsStream();
            respBody = IOUtils.toString((InputStream)in, (String)charset);
            System.out.println("\u63a5\u6536\u62a5\u6587:" + respBody);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return respBody;
    }

    public static Map<String, Object> urlRequest(String url) {
        HashMap<String, Object> mapRequest = new HashMap<String, Object>();
        String[] arrSplit = null;
        String strUrlParam = url;
        if (strUrlParam == null) {
            return mapRequest;
        }
        for (String strSplit : arrSplit = strUrlParam.split("[&]")) {
            String[] arrSplitEqual = null;
            arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if (arrSplitEqual[0] == "") continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    private static String TruncateUrlPage(String strURL) {
        String strAllParam = null;
        String[] arrSplit = null;
        strURL = strURL.trim();
        arrSplit = strURL.split("[?]");
        if (strURL.length() > 1 && arrSplit.length > 1 && arrSplit[1] != null) {
            strAllParam = arrSplit[1];
        }
        return strAllParam;
    }

    public static String sendGet(String url) throws IOException {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        client.executeMethod((HttpMethod)method);
        InputStream in = method.getResponseBodyAsStream();
        String respBody = IOUtils.toString((InputStream)in, (String)StandardCharsets.UTF_8.name());
        return respBody;
    }

    public static String httpRequest(String url) {
        return HttpUtil.httpRequest(url, 15000, 30000);
    }

    public static String httpRequest(String reqUrl, Integer connTimeOut, Integer readTimeOut) {
        StringBuffer buffer = new StringBuffer();
        try {
            URL url = new URL(reqUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
            httpUrlConn.setDoOutput(false);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setConnectTimeout(connTimeOut);
            httpUrlConn.setReadTimeout(readTimeOut);
            httpUrlConn.setRequestMethod("GET");
            httpUrlConn.connect();
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            httpUrlConn.disconnect();
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
        return buffer.toString();
    }
}

