/*
 * Decompiled with CFR 0.152.
 */
package com.zjw.video.open.api.sdk.framework;

import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.zjw.video.open.api.sdk.enums.TokenTypeEnum;
import com.zjw.video.open.api.sdk.exception.ZjwOpenApiException;
import com.zjw.video.open.api.sdk.framework.ZjwVideoOpenApiClient;
import com.zjw.video.open.api.sdk.framework.ZjwVideoOpenApiRequest;
import com.zjw.video.open.api.sdk.framework.ZjwVideoOpenApiResponse;
import com.zjw.video.open.api.sdk.utils.HttpUtil;
import com.zjw.video.open.api.sdk.utils.JwtUtil;
import com.zjw.video.open.api.sdk.utils.UniqueID;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultOpenApiClient
implements ZjwVideoOpenApiClient {
    protected String serverUrl;
    protected String tokenType;
    protected String secret;
    protected String apiEncodeKeys;
    protected String apiAppId;
    protected String apiAppKey;
    protected String apiUserId;

    public DefaultOpenApiClient(String serverUrl, String secret, String apiEncodeKeys, String apiAppId, String apiAppKey, String apiUserId) {
        this.serverUrl = serverUrl;
        this.secret = secret;
        this.apiEncodeKeys = apiEncodeKeys;
        this.apiAppId = apiAppId;
        this.apiAppKey = apiAppKey;
        this.apiUserId = apiUserId;
        this.tokenType = TokenTypeEnum.ZJW_VIDEO_TOKEN.getTokenType();
    }

    @Override
    public <T extends ZjwVideoOpenApiResponse> T execute(ZjwVideoOpenApiRequest<T> request) throws ZjwOpenApiException {
        this.checkParam();
        try {
            String paramJson = "";
            if (Objects.nonNull(request.getParam())) {
                paramJson = JSON.toJSONString((Object)request.getParam());
            }
            String url = DefaultOpenApiClient.createUrl(this.serverUrl, request.getMethod());
            System.out.println("\u8bf7\u6c42\u5730\u5740: " + url);
            System.out.println("\u8bf7\u6c42\u53c2\u6570: " + paramJson);
            Map<String, String> headerMap = this.handleHeaders();
            String data = HttpUtil.sendPost(url, paramJson, headerMap);
            return (T)((ZjwVideoOpenApiResponse)JSON.parseObject((String)data, request.getResponseClass()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZjwOpenApiException("API_CALL_ERROR", "\u63a5\u53e3\u8c03\u7528\u5931\u8d25", e);
        }
    }

    private void checkParam() throws ZjwOpenApiException {
        if (StringUtils.isEmpty((CharSequence)this.serverUrl) || StringUtils.isEmpty((CharSequence)this.secret) || StringUtils.isEmpty((CharSequence)this.apiAppId) || StringUtils.isEmpty((CharSequence)this.apiAppKey) || StringUtils.isEmpty((CharSequence)this.apiEncodeKeys) || StringUtils.isEmpty((CharSequence)this.apiUserId)) {
            throw new ZjwOpenApiException("API_PARAM_ERROR", "\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a\u8bf7\u68c0\u67e5");
        }
    }

    private Map<String, String> handleHeaders() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("tokenType", this.tokenType);
        Long currentTimeMillis = System.currentTimeMillis();
        headerMap.put("X-TIMESTAMP", currentTimeMillis.toString());
        String nonce = UniqueID.generateIdString();
        headerMap.put("X-NONCE", nonce);
        StringBuilder builder = new StringBuilder();
        String sign = builder.append(currentTimeMillis).append("#").append(nonce).append("#").append(this.tokenType).append("#").append(this.secret).toString();
        String ciphertextSign = SecureUtil.md5((String)sign);
        headerMap.put("X-SIGN", ciphertextSign);
        String appToken = JwtUtil.createAppToken(this.apiAppId, this.apiAppKey, this.apiUserId, this.apiEncodeKeys);
        headerMap.put("appAuth", appToken);
        return headerMap;
    }

    static String createUrl(String baseUrl, String method) {
        StringBuilder url = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)baseUrl)) {
            url.append(baseUrl);
            if (!baseUrl.endsWith("/")) {
                url.append('/');
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)method)) {
            url.append(method.replace('.', '/'));
        }
        return url.toString();
    }
}

