/*
 * Decompiled with CFR 0.152.
 */
package com.taikang.oauth2.client.utils.httpclient;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;

public class ProxyMappings {
    private static final ProxyMappings EMPTY_MAPPING = ProxyMappings.valueOf(Collections.emptyList());
    private final List<ProxyMapping> entries;

    public ProxyMappings(List<ProxyMapping> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    public static ProxyMappings valueOf(List<String> proxyMappings) {
        if (proxyMappings == null || proxyMappings.isEmpty()) {
            return EMPTY_MAPPING;
        }
        ArrayList<ProxyMapping> entries = new ArrayList<ProxyMapping>();
        for (String proxyMapping : proxyMappings) {
            entries.add(ProxyMapping.valueOf(proxyMapping));
        }
        return new ProxyMappings(entries);
    }

    public static ProxyMappings valueOf(String ... proxyMappings) {
        if (proxyMappings == null || proxyMappings.length == 0) {
            return EMPTY_MAPPING;
        }
        return ProxyMappings.valueOf(Arrays.asList(proxyMappings));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public HttpHost getProxyFor(String hostname) {
        if (hostname == null) {
            throw new NullPointerException("hostname");
        }
        for (ProxyMapping proxyMapping : this.entries) {
            if (!proxyMapping.matches(hostname)) continue;
            return proxyMapping.getProxy();
        }
        return null;
    }

    public static class ProxyMapping {
        public static final String NO_PROXY = "NO_PROXY";
        private static final String DELIMITER = ";";
        private final Pattern hostnamePattern;
        private final HttpHost proxy;

        public ProxyMapping(Pattern hostnamePattern, HttpHost proxy) {
            this.hostnamePattern = hostnamePattern;
            this.proxy = proxy;
        }

        public Pattern getHostnamePattern() {
            return this.hostnamePattern;
        }

        public HttpHost getProxy() {
            return this.proxy;
        }

        public boolean matches(String hostname) {
            return this.getHostnamePattern().matcher(hostname).matches();
        }

        public static ProxyMapping valueOf(String mapping) {
            String[] mappingTokens = mapping.split(DELIMITER);
            String hostPatternRegex = mappingTokens[0];
            String proxyUriString = mappingTokens[1];
            Pattern hostPattern = Pattern.compile(hostPatternRegex);
            HttpHost proxyHost = ProxyMapping.toProxyHost(proxyUriString);
            return new ProxyMapping(hostPattern, proxyHost);
        }

        private static HttpHost toProxyHost(String proxyUriString) {
            if (NO_PROXY.equals(proxyUriString)) {
                return null;
            }
            URI uri = URI.create(proxyUriString);
            return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }

        public String toString() {
            return "ProxyMapping{hostnamePattern=" + this.hostnamePattern + ", proxy=" + this.proxy + '}';
        }
    }
}

