/*
 * Decompiled with CFR 0.152.
 */
package com.taikang.oauth2.client.utils.httpclient;

import com.taikang.oauth2.client.utils.EnvUtil;
import com.taikang.oauth2.client.utils.KeystoreUtil;
import com.taikang.oauth2.client.utils.httpclient.HttpClientBuilder;
import com.taikang.oauth2.client.utils.httpclient.HttpClientConfig;
import com.taikang.oauth2.client.utils.httpclient.HttpClientFactory;
import com.taikang.oauth2.client.utils.httpclient.ProxyMappings;
import java.io.IOException;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpClientFactory.class);
    private volatile CloseableHttpClient httpClient;
    private HttpClientConfig config;

    @Override
    public HttpClient create() {
        this.lazyInit();
        return this.httpClient;
    }

    @Override
    public void close() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getId() {
        return "default";
    }

    @Override
    public void init(HttpClientConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.httpClient == null) {
            DefaultHttpClientFactory defaultHttpClientFactory = this;
            synchronized (defaultHttpClientFactory) {
                if (this.httpClient == null) {
                    boolean disableTrustManager;
                    long socketTimeout = this.config.getSocketTimeout();
                    long establishConnectionTimeout = this.config.getEstablishConnectionTimeout();
                    int maxPooledPerRoute = this.config.getMaxPooledPerRoute();
                    int connectionPoolSize = this.config.getConnectionPoolSize();
                    long connectionTTL = this.config.getConnectionTTL();
                    long maxConnectionIdleTime = this.config.getMaxConnectionIdleTime();
                    boolean disableCookies = this.config.isDisableCookies();
                    String clientKeystore = this.config.getClientKeystore();
                    String clientKeystorePassword = this.config.getClientKeystorePassword();
                    String clientPrivateKeyPassword = this.config.getClientPrivateKeyPassword();
                    String[] proxyMappings = this.config.getProxyMappings();
                    boolean bl = disableTrustManager = this.config.getTrustStore() == null;
                    if (disableTrustManager) {
                        logger.warn("Truststore is disabled");
                    }
                    HttpClientBuilder.HostnameVerificationPolicy hostnamePolicy = disableTrustManager ? null : HttpClientBuilder.HostnameVerificationPolicy.valueOf(this.config.getHostnameVerificationPolicy());
                    HttpClientBuilder builder = new HttpClientBuilder();
                    builder.socketTimeout(socketTimeout, TimeUnit.MILLISECONDS).establishConnectionTimeout(establishConnectionTimeout, TimeUnit.MILLISECONDS).maxPooledPerRoute(maxPooledPerRoute).connectionPoolSize(connectionPoolSize).connectionTTL(connectionTTL, TimeUnit.MILLISECONDS).maxConnectionIdleTime(maxConnectionIdleTime, TimeUnit.MILLISECONDS).disableCookies(disableCookies).proxyMappings(ProxyMappings.valueOf(proxyMappings));
                    if (this.config.getUserName() != null) {
                        builder.usernamePasswordCredentials(new UsernamePasswordCredentials(this.config.getUserName(), this.config.getPassword()));
                    }
                    if (!disableTrustManager) {
                        builder.hostnameVerification(hostnamePolicy);
                        try {
                            builder.trustStore(this.config.getTrustStore());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to load truststore", e);
                        }
                    }
                    if (clientKeystore != null) {
                        clientKeystore = EnvUtil.replace(clientKeystore);
                        try {
                            KeyStore clientCertKeystore = KeystoreUtil.loadKeyStore(clientKeystore, clientKeystorePassword);
                            builder.keyStore(clientCertKeystore, clientPrivateKeyPassword);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to load keystore", e);
                        }
                    }
                    this.httpClient = builder.build();
                }
            }
        }
    }
}

