/*
 * Decompiled with CFR 0.152.
 */
package com.taikang.oauth2.client.utils;

import com.taikang.oauth2.client.utils.FindFile;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;

public class KeystoreUtil {
    public static KeyStore loadKeyStore(String filename, String password) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream trustStream = FindFile.findFile(filename);
        trustStore.load(trustStream, password.toCharArray());
        trustStream.close();
        return trustStore;
    }

    public static KeyPair loadKeyPairFromKeystore(String keystoreFile, String storePassword, String keyPassword, String keyAlias, KeystoreFormat format) {
        InputStream stream = FindFile.findFile(keystoreFile);
        try {
            KeyStore keyStore = null;
            keyStore = format == KeystoreFormat.JKS ? KeyStore.getInstance(format.toString()) : KeyStore.getInstance(format.toString(), "BC");
            keyStore.load(stream, storePassword.toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword.toCharArray());
            if (privateKey == null) {
                throw new RuntimeException("Couldn't load key with alias '" + keyAlias + "' from keystore");
            }
            PublicKey publicKey = keyStore.getCertificate(keyAlias).getPublicKey();
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load private key: " + e.getMessage(), e);
        }
    }

    public static enum KeystoreFormat {
        JKS,
        PKCS12;

    }
}

