/*
 * Decompiled with CFR 0.152.
 */
package com.taikang.oauth2.client.auth;

import com.taikang.oauth2.client.MemoryTokenStore;
import com.taikang.oauth2.client.auth.ErrorResponse;
import com.taikang.oauth2.client.auth.TokenResponse;
import com.taikang.oauth2.client.config.OAuth2Config;
import com.taikang.oauth2.client.utils.SimpleHttp;
import com.taikang.oauth2.client.utils.httpclient.DefaultHttpClientFactory;
import com.taikang.oauth2.client.utils.httpclient.HttpClientConfig;
import com.taikang.oauth2.client.utils.httpclient.HttpClientFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClientCredentialsHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClientCredentialsHandler.class);
    private static OAuth2Config oauth2Config;
    private final HttpClientFactory httpClientFactory;
    private static String OAUTH_VERSION;
    private static final String GRANT_TYPE = "client_credentials";
    private static final long TOKEN_REFRESH_LEAD_TIME = 10000L;
    private static final long TOKEN_REFRESH_AHEAD_TIME = 600000L;

    @Autowired
    public ClientCredentialsHandler(OAuth2Config oauth2Config) {
        ClientCredentialsHandler.oauth2Config = oauth2Config;
        this.httpClientFactory = new DefaultHttpClientFactory();
        HttpClientConfig config = new HttpClientConfig();
        config.setUserName(oauth2Config.getClientId());
        config.setPassword(oauth2Config.getClientSecret());
        this.httpClientFactory.init(config);
        MemoryTokenStore.EXPIRES_AT = 0L;
        logger.debug("ClientCredentialsHandler (re)initialized");
    }

    public String getEffectiveAccessToken() {
        block7: {
            boolean isRefresh = false;
            try {
                if (MemoryTokenStore.ACCESS_TOKEN == null || "".equals(MemoryTokenStore.ACCESS_TOKEN)) {
                    this.doAuth();
                } else {
                    long remainTime = MemoryTokenStore.EXPIRES_AT - System.currentTimeMillis();
                    if (remainTime < 10000L || remainTime < 600000L && !MemoryTokenStore.IS_REFRESHING_TOKEN) {
                        isRefresh = true;
                        this.doAuth();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Get access token error: {}", (Object)e.getMessage());
                try {
                    logger.info("Do auth again ...");
                    this.forceAuth();
                }
                catch (Exception e1) {
                    logger.error("Auth finally error: {}", (Object)e.getMessage());
                    if (isRefresh) break block7;
                    throw new RuntimeException("Get access token error and reauth failed.", e1);
                }
            }
        }
        return MemoryTokenStore.ACCESS_TOKEN;
    }

    private synchronized void doAuth() throws Exception {
        if (MemoryTokenStore.ACCESS_TOKEN == null || "".equals(MemoryTokenStore.ACCESS_TOKEN)) {
            logger.info("No token found, do taikang authentication ...");
            this.auth();
        } else if (MemoryTokenStore.EXPIRES_AT - System.currentTimeMillis() < 600000L) {
            logger.info("Token is about to expire, do refreshing ...");
            this.auth();
        }
    }

    private synchronized void forceAuth() throws Exception {
        logger.info("Forced to do taikang authentication...");
        this.auth();
    }

    private void auth() throws Exception {
        MemoryTokenStore.IS_REFRESHING_TOKEN = true;
        try {
            SimpleHttp simpleHttp = SimpleHttp.doPost(oauth2Config.getTokenUrl(), this.httpClientFactory.create()).header("oauth_version", OAUTH_VERSION).param("grant_type", GRANT_TYPE).param("scope", oauth2Config.getScope()).param("state", String.valueOf(System.currentTimeMillis()));
            SimpleHttp.Response response = simpleHttp.asResponse();
            ClientCredentialsHandler.handleAuthResponse(response);
        }
        finally {
            MemoryTokenStore.IS_REFRESHING_TOKEN = false;
        }
    }

    private static void handleAuthResponse(SimpleHttp.Response response) throws IOException {
        if (response.getStatus() != 200) {
            ErrorResponse errorResponse;
            if (response.getHeader("WWW-Authenticate") != null) {
                logger.info("Http header WWW-Authenticate: " + response.getHeader("WWW-Authenticate"));
            }
            if ((errorResponse = response.asJson(ErrorResponse.class)) == null || errorResponse.getError() == null || "".equals(errorResponse.getError())) {
                logger.error("Parse error response failed, response: \n {}", (Object)response.asString());
                throw new RuntimeException("Parse error response failed, response:" + response.asString());
            }
            logger.error("Do taikang authentication failed, error: {}, error_description: {}", (Object)errorResponse.getError(), (Object)errorResponse.getError_description());
            throw new RuntimeException("Do taikang authentication failed, error: " + errorResponse.getError() + ", error_description: " + errorResponse.getError_description());
        }
        TokenResponse tokenResponse = response.asJson(TokenResponse.class);
        if (tokenResponse != null && tokenResponse.getToken_type() != null && !"".equals(tokenResponse.getToken_type())) {
            if (!"Bearer".equalsIgnoreCase(tokenResponse.getToken_type())) {
                logger.error("Unsupported token type: {}", (Object)tokenResponse.getToken_type());
                throw new RuntimeException("Unsupported token type: " + tokenResponse.getToken_type());
            }
        } else {
            logger.error("Parse token response failed, response: {}", (Object)response.asString());
            throw new RuntimeException("Parse token response failed, response:" + response.asString());
        }
        MemoryTokenStore.TOKEN_TYPE = "Bearer";
        MemoryTokenStore.ACCESS_TOKEN = tokenResponse.getAccess_token();
        MemoryTokenStore.EXPIRES_AT = System.currentTimeMillis() + tokenResponse.getExpires_in() * 1000L;
        logger.debug("Access token: {}", (Object)MemoryTokenStore.ACCESS_TOKEN);
        logger.info("Do taikang authentication success ...");
    }

    public static OAuth2Config getOauth2Config() {
        return oauth2Config;
    }

    public static void setOauth2Config(OAuth2Config oauth2Config) {
        ClientCredentialsHandler.oauth2Config = oauth2Config;
    }

    static {
        OAUTH_VERSION = "dev";
        Package pkg = ClientCredentialsHandler.class.getPackage();
        String title = pkg.getImplementationTitle();
        String version = pkg.getImplementationVersion();
        OAUTH_VERSION = title + ":" + version + ",runtime-jdk:" + System.getProperty("java.version");
        logger.debug("Oauth version: {}", (Object)OAUTH_VERSION);
    }
}

