/*
 * Decompiled with CFR 0.152.
 */
package com.taikang.oauth2.client;

import com.taikang.oauth2.client.MemoryTokenStore;
import com.taikang.oauth2.client.auth.ClientCredentialsHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OAuth2ContextHelper {
    private static ClientCredentialsHandler clientCredentialsHandler;

    @Autowired
    public OAuth2ContextHelper(ClientCredentialsHandler clientCredentialsHandler) {
        OAuth2ContextHelper.clientCredentialsHandler = clientCredentialsHandler;
    }

    public static String getAuthorizationHeader() {
        if (clientCredentialsHandler == null) {
            throw new RuntimeException("OAuth2 client use incorrectly, ClientCredentialsHandler is null");
        }
        String accessToken = clientCredentialsHandler.getEffectiveAccessToken();
        if (accessToken == null) {
            throw new RuntimeException("Access token is null, access will be denied");
        }
        if ("Bearer".equalsIgnoreCase(MemoryTokenStore.TOKEN_TYPE)) {
            return "Bearer " + accessToken;
        }
        return MemoryTokenStore.TOKEN_TYPE + " " + accessToken;
    }

    public static ClientCredentialsHandler getClientCredentialsHandler() {
        return clientCredentialsHandler;
    }

    public static void setClientCredentialsHandler(ClientCredentialsHandler clientCredentialsHandler) {
        OAuth2ContextHelper.clientCredentialsHandler = clientCredentialsHandler;
    }
}

