/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.Client;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.storage.BigFileExtUploader;
import com.pingan.iobs.sdk.storage.BigFileNotifier;
import com.pingan.iobs.sdk.storage.BigFileUploader;
import com.pingan.iobs.sdk.storage.FormUploader;
import com.pingan.iobs.sdk.storage.ResumeUploader;
import com.pingan.iobs.sdk.util.StringMap;
import java.io.File;
import java.io.InputStream;

public final class UploadManager {
    private String SERVICE_PATH_GETKEY = "/getUploadKey";
    private final Client client = Client.getInstance();

    public Response getUploadKey(String token) throws IOBSException {
        StringBuffer sb = new StringBuffer();
        sb.append(Config.HOST).append(this.SERVICE_PATH_GETKEY).append("?token=").append(token);
        return this.client.get(sb.toString());
    }

    private static void checkArgs(String key, byte[] data, File f, String token) {
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public Response put(File file, String bucket, String key, String token, boolean iat) throws IOBSException {
        return this.put(file, bucket, key, token, null, null, iat);
    }

    public Response put(File file, String bucket, String key, String token, String persistentOps, String persistentNotifyUrl, boolean iat) throws IOBSException {
        long size = file.length();
        if (size <= (long)Config.PUT_THRESHOLD) {
            return new FormUploader(this.client, token, bucket, key, file, persistentOps, persistentNotifyUrl).upload();
        }
        ResumeUploader uploader = new ResumeUploader(token, bucket, key, file, iat);
        return uploader.execute();
    }

    public Response put(File file, String bucket, String token) throws IOBSException {
        return this.put(file, bucket, token, null, null);
    }

    public Response put(File file, String bucket, String token, String persistentOps, String persistentNotifyUrl) throws IOBSException {
        return new FormUploader(this.client, token, bucket, file, persistentOps, persistentNotifyUrl).upload();
    }

    private static StringMap filterParam(StringMap params) {
        final StringMap ret = new StringMap();
        if (params == null) {
            return ret;
        }
        params.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                if (value == null) {
                    return;
                }
                String val = value.toString();
                if (key.startsWith("x:") && !val.equals("")) {
                    ret.put(key, val);
                }
            }
        });
        return ret;
    }

    public Response putStream(String bucket, String key, InputStream ins, String fileName, String token, long length) throws IOBSException {
        return this.putStream(bucket, key, ins, fileName, token, length, null, null);
    }

    public Response putStream(String bucket, String key, InputStream ins, String fileName, String token, long length, String persistentOps, String persistentNotifyUrl) throws IOBSException {
        return new FormUploader(this.client, token, bucket, key, ins, fileName, length, persistentOps, persistentNotifyUrl).uploadStream();
    }

    public Response putStream(String bucket, InputStream ins, String fileName, String token, long length) throws IOBSException {
        return this.putStream(bucket, ins, fileName, token, length, null, null);
    }

    public Response putStream(String bucket, InputStream ins, String fileName, String token, long length, String persistentOps, String persistentNotifyUrl) throws IOBSException {
        return new FormUploader(this.client, token, bucket, ins, fileName, length, persistentOps, persistentNotifyUrl).uploadStream();
    }

    public Response putBigFile(File file, String bucket, String key, String token, boolean iat, BigFileNotifier bigFileNotifier) throws IOBSException {
        long fileSize = file.length();
        if (fileSize < 524288000L) {
            throw new IOBSException("file size must over 500MB");
        }
        BigFileUploader bigFileUploader = bigFileNotifier == null ? new BigFileUploader(file, bucket, key, token, iat, file.getName(), fileSize) : new BigFileExtUploader(file, bucket, key, token, iat, file.getName(), fileSize, bigFileNotifier);
        return bigFileUploader.execute();
    }
}

