/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.google.gson.Gson;
import com.pingan.iobs.sdk.auth.AuthException;
import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.HttpClientFactory;
import com.pingan.iobs.sdk.model.Context;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.storage.FileRecorder;
import com.pingan.iobs.sdk.storage.UploadBlock;
import com.pingan.iobs.sdk.util.Auth;
import com.pingan.iobs.sdk.util.MD5Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public class ResumeUploader {
    private String upToken;
    private final String bucket;
    private final String key;
    private final File file;
    private final FileRecorder recorder;
    private List<Context> contextList;
    private RandomAccessFile randomAccessFile;
    private static final String MKFILE_SERVICE = "/mkfile";
    private final boolean iat;

    public ResumeUploader(String upToken, String bucket, String key, File file, boolean iat) throws IOBSException {
        try {
            this.upToken = upToken;
            this.bucket = bucket;
            this.key = key;
            this.file = file;
            this.recorder = new FileRecorder(Config.TEMP_FILE_PATH + File.separator + "iobs");
            this.randomAccessFile = new RandomAccessFile(file, "r");
            this.iat = iat;
        }
        catch (IOException e) {
            throw new IOBSException(e);
        }
    }

    public Response execute() throws IOBSException {
        try {
            this.contextList = this.getContextList();
            this.sliceAndUpload();
            Response putResult = this.mkFile();
            this.recorder.del(this.bucket, this.key);
            Response response = putResult;
            return response;
        }
        catch (AuthException | IOException | InterruptedException | NoSuchAlgorithmException e) {
            throw new IOBSException(e);
        }
        finally {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                throw new IOBSException(e);
            }
        }
    }

    private void sliceAndUpload() throws IOException, InterruptedException, IOBSException, AuthException {
        for (Context ctx : this.contextList) {
            if (ctx.isUploadOver()) continue;
            if (this.iat) {
                this.upToken = Auth.newUpToken(this.bucket, this.key);
            }
            this.uploadBlock(ctx);
            this.recordContextList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response mkFile() throws IOException, NoSuchAlgorithmException, InterruptedException, AuthException {
        HttpPost httpPost = null;
        try {
            Map<String, String> paramMap = this.getParamMap();
            String mkFileUrl = this.getMkFileUrl();
            String mkFileUrlWithParams = this.createUrlWithParams(paramMap, mkFileUrl);
            HttpClient httpClient = HttpClientFactory.createHttpClient();
            httpPost = new HttpPost(mkFileUrlWithParams);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("fileName", this.file.getName())), "utf-8");
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);
            Response response = Response.createBaseResponse(resp);
            this.releaseConnection(httpPost);
            return response;
        }
        catch (Throwable throwable) {
            this.releaseConnection(httpPost);
            throw throwable;
        }
    }

    private void releaseConnection(HttpPost post) {
        if (post != null) {
            post.releaseConnection();
        }
    }

    public String getMkFileUrl() {
        StringBuffer sb = new StringBuffer();
        return sb.append(Config.HOST).append(MKFILE_SERVICE).append("/").append(this.bucket).append("/").append(this.key).toString();
    }

    private String createUrlWithParams(Map<String, String> paramMap, String basicUrl) {
        StringBuffer sb = new StringBuffer();
        sb.append(basicUrl).append("?");
        for (String key : paramMap.keySet()) {
            sb.append(key).append("=").append(paramMap.get(key)).append("&");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private Map<String, String> getParamMap() throws IOException, NoSuchAlgorithmException, AuthException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String md5 = this.bigFileMD5(this.file);
        if (this.iat) {
            this.upToken = Auth.newUpToken(this.bucket, this.key);
        }
        paramMap.put("token", this.upToken);
        paramMap.put("fileSize", String.valueOf(this.file.length()));
        paramMap.put("md5", md5);
        return paramMap;
    }

    private String bigFileMD5(File bigFile) throws NoSuchAlgorithmException, IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream fis = new FileInputStream(bigFile);
        byte[] bytes = new byte[Config.BLOCK_SIZE];
        int len = 0;
        while ((len = fis.read(bytes)) != -1) {
            if (len != Config.BLOCK_SIZE) {
                int remainLen = (int)(bigFile.length() % (long)Config.BLOCK_SIZE);
                sb.append(MD5Utils.MD5(Arrays.copyOf(bytes, remainLen)));
                continue;
            }
            sb.append(MD5Utils.MD5(bytes));
        }
        fis.close();
        return MD5Utils.MD5(sb.toString().getBytes());
    }

    private void uploadBlock(Context context) throws IOException, InterruptedException, IOBSException {
        long start = (long)(context.getBlockId() - 1) * Long.valueOf(Config.BLOCK_SIZE);
        int len = (int)Math.min((long)Config.BLOCK_SIZE, this.file.length() - start);
        UploadBlock uploadBlock = new UploadBlock(this, context, start, len, this.randomAccessFile);
        uploadBlock.execute();
    }

    private List<Context> getContextList() throws IOException {
        byte[] bytes = this.recorder.get(this.bucket, this.key);
        if (bytes == null) {
            return this.recorder.initRecorder(this.file, this.bucket, this.key);
        }
        return this.recorder.getRecordCtxList(this.bucket, this.key);
    }

    public void recordContextList() {
        String contextListJson = new Gson().toJson(this.contextList);
        this.recorder.set(this.bucket, this.key, contextListJson.getBytes());
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getUpToken() {
        return this.upToken;
    }

    public String getKey() {
        return this.key;
    }

    public File getFile() {
        return this.file;
    }
}

