/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.model.Context;
import com.pingan.iobs.sdk.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileRecorder {
    private final File directory;

    public FileRecorder(String dirPath) throws IOException {
        this.directory = new File(dirPath);
        if (!this.directory.exists()) {
            FileUtils.createDirs(dirPath);
        }
        if (!this.directory.isDirectory()) {
            throw new IOException("does not mkdir");
        }
    }

    public void set(String bucket, String key, byte[] data) {
        String fileName = bucket + "_" + key + ".json";
        File f = new File(this.directory, fileName);
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(f);
            fo.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fo != null) {
            try {
                fo.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public byte[] get(String bucket, String key) {
        String fileName = bucket + "_" + key + ".json";
        File f = new File(this.directory, fileName);
        if (!f.exists()) {
            return null;
        }
        FileInputStream fi = null;
        byte[] data = new byte[(int)f.length()];
        int read = 0;
        try {
            fi = new FileInputStream(f);
            read = fi.read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fi != null) {
            try {
                fi.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (read == 0) {
            return null;
        }
        return data;
    }

    public List<Context> initRecorder(File file, String bucket, String key) {
        ArrayList<Context> contextList = new ArrayList<Context>();
        int blockCount = (int)(file.length() / (long)Config.BLOCK_SIZE);
        if (file.length() % (long)Config.BLOCK_SIZE != 0L) {
            ++blockCount;
        }
        for (int blockIndex = 1; blockIndex <= blockCount; ++blockIndex) {
            contextList.add(new Context(blockIndex, 0, false));
        }
        String ctxJosn = new Gson().toJson(contextList);
        this.set(bucket, key, ctxJosn.getBytes());
        return contextList;
    }

    public List<Context> getRecordCtxList(String bucket, String key) {
        byte[] bytes = this.get(bucket, key);
        String cxtListJson = new String(bytes);
        return (List)new Gson().fromJson(cxtListJson, new TypeToken<List<Context>>(){}.getType());
    }

    public void del(String bucket, String key) {
        String fileName = bucket + "_" + key + ".json";
        File f = new File(this.directory, fileName);
        f.delete();
    }
}

