/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.pingan.iobs.sdk.auth.AuthException;
import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.HttpClientFactory;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.storage.BigFileRecorder;
import com.pingan.iobs.sdk.util.Auth;
import com.pingan.iobs.sdk.util.MD5Utils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class BigFileUploader {
    private static final String initPartFormat = "%s/initUploadPart/%s/%s?token=%s&fileName=%s&fileSize=%s";
    private static final String uploadPartFormat = "%s/uploadPart/%s/%s?token=%s&uploadId=%s&partNumber=%s";
    private static final String completeFormat = "%s/completeUpload/%s/%s?token=%s&uploadId=%s&fileName=%s";
    private RandomAccessFile file;
    private String bucket;
    private String key;
    private String token;
    private boolean iat;
    private long iatTime;
    protected BigFileRecorder recorder;
    private HttpClient httpClient;

    public BigFileUploader(File file, String bucket, String key, String token, boolean iat, String fileName, long fileSize) throws IOBSException {
        try {
            this.file = new RandomAccessFile(file, "r");
            this.bucket = bucket;
            this.key = key;
            this.token = token;
            this.iat = iat;
            this.recorder = new BigFileRecorder(bucket, key, fileSize, fileName);
            this.httpClient = HttpClientFactory.createHttpClient();
            this.iatTime = System.currentTimeMillis() + (long)Config.BIG_FILE_TOKEN_REFRESH_INTERVAL;
        }
        catch (IOException e) {
            throw new IOBSException(e);
        }
    }

    public Response execute() throws IOBSException {
        try {
            this.initUploadPart();
            this.uploadPart();
            return this.completeUpload();
        }
        catch (AuthException | IOException | NoSuchAlgorithmException | DecoderException e) {
            throw new IOBSException((Exception)e);
        }
    }

    private void initUploadPart() throws AuthException, IOException, IOBSException {
        if (StringUtils.isNotEmpty((String)this.recorder.uploadId)) {
            return;
        }
        String url = String.format(initPartFormat, Config.HOST, this.bucket, this.key, this.getToken(), URLEncoder.encode(this.recorder.fileName, "utf-8"), String.valueOf(this.recorder.fileSize));
        String message = this.sendPostWithoutEntity(url);
        this.recorder.refreshUploadId(message);
    }

    private void uploadPart() throws IOException, NoSuchAlgorithmException, AuthException, IOBSException {
        long offset = (long)(this.recorder.partNumber - 1) * 0x500000L;
        while (this.recorder.partNumber < this.recorder.partCount) {
            this.uploadPart(this.splitFile(offset, 0x500000));
            offset += 0x500000L;
        }
        this.uploadPart(this.splitFile(offset, (int)(this.recorder.fileSize - offset)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response completeUpload() throws AuthException, IOException, DecoderException, IOBSException, NoSuchAlgorithmException {
        String url = String.format(completeFormat, Config.HOST, this.bucket, this.key, this.getToken(), this.recorder.uploadId, URLEncoder.encode(this.recorder.fileName, "utf-8"));
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(url);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("partMap", this.recorder.partMap.toString())), "utf-8");
            httpPost.setEntity((HttpEntity)entity);
            HttpClient httpClient = HttpClientFactory.createHttpClient();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int code = httpResponse.getStatusLine().getStatusCode();
            if (code == 200) {
                this.recorder.clean();
                if (Config.BIG_FILE_IS_ETAG_VALIDATE) {
                    String message = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
                    String etag = (String)((Map)new Gson().fromJson(message, Map.class)).get("hash");
                    Set entrySet = this.recorder.partMap.entrySet();
                    if (entrySet.isEmpty()) {
                        throw new IOBSException("etag not match! please upload again.");
                    }
                    Iterator iterator = entrySet.iterator();
                    byte[] etagBytes = Hex.decodeHex((char[])((JsonElement)((Map.Entry)iterator.next()).getValue()).getAsString().toCharArray());
                    while (iterator.hasNext()) {
                        etagBytes = ArrayUtils.addAll((byte[])etagBytes, (byte[])Hex.decodeHex((char[])((JsonElement)((Map.Entry)iterator.next()).getValue()).getAsString().toCharArray()));
                    }
                    String localEtag = MD5Utils.MD5(etagBytes) + "-" + entrySet.size();
                    if (!StringUtils.equalsIgnoreCase((String)etag, (String)localEtag)) {
                        throw new IOBSException("etag not match! please upload again.");
                    }
                    Response response = Response.createBaseResponse(code, message);
                    return response;
                }
            }
            Response response = Response.createBaseResponse(httpResponse);
            return response;
        }
        finally {
            this.releaseConnection(httpPost);
        }
    }

    private String getToken() throws AuthException {
        long currentMillis = System.currentTimeMillis();
        if (this.iat && this.iatTime < currentMillis) {
            this.token = Auth.newUpToken(this.bucket);
            this.iatTime = currentMillis + (long)Config.BIG_FILE_TOKEN_REFRESH_INTERVAL;
        }
        return this.token;
    }

    private byte[] splitFile(long offset, int length) throws IOException {
        byte[] buffer = new byte[length];
        this.file.seek(offset);
        this.file.read(buffer, 0, length);
        return buffer;
    }

    protected void uploadPart(byte[] bytes) throws IOException, IOBSException, AuthException, NoSuchAlgorithmException {
        ByteArrayEntity entity = new ByteArrayEntity(bytes);
        String url = String.format(uploadPartFormat, Config.HOST, this.bucket, this.key, this.getToken(), this.recorder.uploadId, String.valueOf(this.recorder.partNumber));
        String message = this.sendPostWithEntity(url, (HttpEntity)entity);
        String etag = (String)((Map)new Gson().fromJson(message, Map.class)).get("hash");
        if (Config.BIG_FILE_IS_ETAG_VALIDATE && !StringUtils.equalsIgnoreCase((String)MD5Utils.MD5(bytes), (String)etag)) {
            throw new IOBSException("etag not match! please retry.");
        }
        this.recorder.refreshPartNumber(etag);
    }

    private String sendPostWithEntity(String url, HttpEntity entity) throws IOException, IOBSException {
        HttpPost post = new HttpPost(url);
        post.setEntity(entity);
        return this.sendPost(post);
    }

    private String sendPostWithoutEntity(String url) throws IOException, IOBSException {
        HttpPost post = new HttpPost(url);
        return this.sendPost(post);
    }

    private String sendPost(HttpPost post) throws IOException, IOBSException {
        try {
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)post);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
                return string;
            }
            throw new IOBSException(Response.createBaseResponse(httpResponse));
        }
        finally {
            this.releaseConnection(post);
        }
    }

    private void releaseConnection(HttpPost httpPost) {
        if (null != httpPost) {
            httpPost.releaseConnection();
        }
    }
}

