/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pingan.iobs.sdk.common.Config;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.apache.commons.lang.StringUtils;

public class BigFileRecorder {
    String bucket;
    String key;
    long fileSize;
    String fileName;
    int partCount;
    String uploadId;
    int partNumber;
    JsonObject partMap;
    final String bigFileCacheBasePath = Config.TEMP_FILE_PATH + File.separator + "iobs" + File.separator + "bigfile";

    public BigFileRecorder(String bucket, String key, long fileSize, String fileName) throws IOException {
        File baseDir = new File(this.bigFileCacheBasePath);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        this.bucket = bucket;
        this.key = key;
        this.fileSize = fileSize;
        this.fileName = fileName;
        File cache = new File(String.format("%s/%s_%s.json", this.bigFileCacheBasePath, bucket, key));
        if (cache.exists()) {
            InputStreamReader reader = new InputStreamReader(new FileInputStream(cache));
            BigFileRecorder recorder = (BigFileRecorder)new Gson().fromJson((Reader)reader, this.getClass());
            reader.close();
            if (recorder.fileSize == fileSize && StringUtils.equals((String)recorder.fileName, (String)fileName)) {
                this.partCount = recorder.partCount;
                this.uploadId = recorder.uploadId;
                this.partNumber = recorder.partNumber;
                this.partMap = recorder.partMap;
                this.flush();
                return;
            }
        }
        this.init();
    }

    public void refreshUploadId(String uploadId) throws IOException {
        this.uploadId = uploadId;
        this.flush();
    }

    public void refreshPartNumber(String hash) throws IOException {
        this.partMap.addProperty(String.valueOf(this.partNumber++), hash);
        if (this.partNumber % Config.BIG_FILE_CACHE_REFRESH_RATE == 0 || this.partNumber > this.partCount) {
            this.flush();
        }
    }

    public void clean() {
        File cache = new File(String.format("%s/%s_%s.json", this.bigFileCacheBasePath, this.bucket, this.key));
        cache.delete();
    }

    private void init() throws IOException {
        this.partCount = (int)(this.fileSize / 0x500000L) + 1;
        this.uploadId = "";
        this.partNumber = 1;
        this.partMap = new JsonObject();
        this.flush();
    }

    private void flush() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(String.format("%s/%s_%s.json", this.bigFileCacheBasePath, this.bucket, this.key))));
        bufferedWriter.write(this.toString());
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public String toString() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("bucket", this.bucket);
        jsonObject.addProperty("key", this.key);
        jsonObject.addProperty("fileSize", (Number)this.fileSize);
        jsonObject.addProperty("fileName", this.fileName);
        jsonObject.addProperty("partCount", (Number)this.partCount);
        jsonObject.addProperty("uploadId", this.uploadId);
        jsonObject.addProperty("partNumber", (Number)this.partNumber);
        jsonObject.add("partMap", (JsonElement)this.partMap);
        return jsonObject.toString();
    }
}

