/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.model;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class Response {
    public static final int NetworkError = -1;
    private HttpResponse httpResponse;
    private ResponseJson responseJson;
    private String error;

    public int code() {
        return this.responseJson.code;
    }

    public String error() {
        return this.error;
    }

    public String message() {
        return this.responseJson.message;
    }

    public InputStream downloadFileStream() throws IllegalStateException, IOException {
        return this.httpResponse.getEntity().getContent();
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public boolean isOK() {
        return this.responseJson.code == 200 && this.error == null;
    }

    public boolean isServerError() {
        return this.responseJson.code >= 500 && this.responseJson.code < 600 && this.responseJson.code != 579 || this.responseJson.code == 996;
    }

    public boolean needRetry() {
        return this.isNetworkBroken() || this.isServerError() || this.responseJson.code == 406 || this.responseJson.code == 200 && this.error != null;
    }

    public boolean isNetworkBroken() {
        return this.responseJson.code == -1;
    }

    public Response(int code, String error) {
        this(null, code, error, null);
    }

    public Response(int code, String error, String message) {
        this(null, code, error, message);
    }

    public Response(HttpResponse response, int code, String error, String message) {
        this.error = error;
        this.responseJson = new ResponseJson(code, message);
        this.httpResponse = response;
    }

    private static String getErrorMessage(HttpResponse response, int code) {
        String error;
        block3: {
            error = null;
            try {
                if (code >= 400) {
                    error = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                }
            }
            catch (Exception e) {
                if (code >= 300) break block3;
                error = e.getMessage();
            }
        }
        return error;
    }

    public static Response createBaseResponse(HttpResponse response) {
        String error = null;
        String message = null;
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            error = Response.getErrorMessage(response, code);
        } else {
            try {
                message = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            catch (IOException e) {
                error = e.getMessage();
            }
        }
        return new Response(response, code, error, message);
    }

    public static Response createBaseResponse(int code, String message) {
        String error = null;
        if (code != 200) {
            error = message;
        }
        return new Response(null, code, error, message);
    }

    public static Response createDownloadResponse(HttpResponse response) {
        String error = null;
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            error = Response.getErrorMessage(response, code);
        }
        return new Response(response, code, error, null);
    }

    class ResponseJson {
        public int code;
        public String message;

        public ResponseJson(int code, String message) {
            this.code = code;
            this.message = message;
        }
    }
}

