/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.http;

import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.HttpClientFactory;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.util.StringMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;

public final class Client {
    public static final String ContentTypeHeader = "Content-Type";
    public static final String DefaultMime = "application/octet-stream";
    public static final String JsonMime = "application/json";
    public static final String FormMime = "application/x-www-form-urlencoded";
    private static HttpClient httpClient = HttpClientFactory.createHttpClient();
    private static Client client = new Client();

    private Client() {
    }

    public static Client getInstance() {
        return client;
    }

    private static String userAgent() {
        String javaVersion = "Java/" + System.getProperty("java.version");
        String os = System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        String sdk = "QiniuJava/6.1.9";
        return sdk + " (" + os + ") " + javaVersion;
    }

    public Response get(String url) throws IOBSException {
        return this.get(url, new StringMap());
    }

    public Response download(String url) throws IOBSException {
        return this.download(url, new StringMap());
    }

    public Response delete(String url) throws IOBSException {
        return this.delete(url, new StringMap());
    }

    public Response delete(String url, StringMap headers) throws IOBSException {
        HttpResponse httpResponse;
        final HttpGet httpGet = new HttpGet(url);
        if (headers != null) {
            headers.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    httpGet.addHeader(key, value + "");
                }
            });
        }
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            throw new IOBSException(e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return Response.createBaseResponse(httpResponse);
    }

    public Response get(String url, StringMap headers) throws IOBSException {
        HttpGet httpGet = new HttpGet(url);
        this.setHttpHeaders(headers, httpGet);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            Response response = Response.createBaseResponse(httpResponse);
            return response;
        }
        catch (IOException e) {
            throw new IOBSException(e);
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    public Response download(String url, StringMap headers) throws IOBSException {
        HttpResponse httpResponse;
        HttpGet httpGet = new HttpGet(url);
        this.setHttpHeaders(headers, httpGet);
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            httpGet.releaseConnection();
            throw new IOBSException(e);
        }
        return Response.createDownloadResponse(httpResponse);
    }

    private void setHttpHeaders(StringMap headers, final HttpGet httpGet) {
        if (headers != null) {
            headers.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    httpGet.addHeader(key, value + "");
                }
            });
        }
    }

    public Response post(String url, File file, StringMap params) throws IOBSException {
        return this.post(url, file, null, params);
    }

    public Response post(String url, File file, StringMap headers, StringMap params) throws IOBSException {
        return this.send(url, headers, params, file);
    }

    private void addHeaders(final HttpPost httpPost, StringMap headers) {
        headers.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                httpPost.addHeader(key, value + "");
            }
        });
        httpPost.addHeader("User-Agent", Client.userAgent());
    }

    private void addParams(HttpPost httpPost, StringMap params, File file) {
        MultipartEntityBuilder entityBuilder = this.getMultipartEntityBuilder(params);
        if (file != null) {
            entityBuilder.addBinaryBody("file", file);
        }
        httpPost.setEntity(entityBuilder.build());
    }

    private MultipartEntityBuilder getMultipartEntityBuilder(StringMap params) {
        final MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.setCharset(Charset.forName("UTF-8"));
        entityBuilder.setCharset(Charset.forName("utf-8"));
        if (params != null) {
            params.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    entityBuilder.addTextBody(key, value + "");
                }
            });
        }
        return entityBuilder;
    }

    private void setBaseEntityBuilderParams(StringMap params, final MultipartEntityBuilder entityBuilder) {
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.setCharset(Charset.forName("UTF-8"));
        entityBuilder.setCharset(Charset.forName("utf-8"));
        if (params != null) {
            params.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    entityBuilder.addTextBody(key, value + "");
                }
            });
        }
    }

    public Response send(String url, StringMap headers, StringMap params, File file) throws IOBSException {
        HttpPost httpPost = new HttpPost(url);
        if (headers != null) {
            this.addHeaders(httpPost, headers);
        }
        this.addParams(httpPost, params, file);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            Response response = Response.createBaseResponse(httpResponse);
            return response;
        }
        catch (IOException e) {
            throw new IOBSException(e);
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    public Response post(String url, InputStream ins, String fileName, long length, StringMap params) throws IOBSException {
        return this.post(url, ins, fileName, length, null, params);
    }

    private Response post(String url, InputStream ins, String fileName, long length, StringMap headers, StringMap params) throws IOBSException {
        return this.send(url, ins, fileName, length, headers, params);
    }

    private Response send(String url, InputStream ins, String fileName, long length, StringMap headers, StringMap params) throws IOBSException {
        HttpPost httpPost = new HttpPost(url);
        if (headers != null) {
            this.addHeaders(httpPost, headers);
        }
        this.addParams(httpPost, params, ins, fileName, length);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            Response response = Response.createBaseResponse(httpResponse);
            return response;
        }
        catch (IOException e) {
            throw new IOBSException(e);
        }
        finally {
            httpPost.releaseConnection();
            this.closeIns(ins);
        }
    }

    private void closeIns(InputStream ins) {
        if (ins != null) {
            try {
                ins.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addParams(HttpPost httpPost, StringMap params, InputStream ins, String fileName, long length) {
        MultipartEntityBuilder entityBuilder = this.getMultipartEntityBuilder(params);
        if (fileName == null) {
            fileName = "iobs.tmp";
        }
        AbstractContentBody inputBody = this.buildInputStreamBody(ins, fileName, length);
        entityBuilder.addPart("file", (ContentBody)inputBody);
        httpPost.setEntity(entityBuilder.build());
    }

    private AbstractContentBody buildInputStreamBody(InputStream ins, String fileName, final long length) {
        return new InputStreamBody(ins, fileName){

            public long getContentLength() {
                return length;
            }
        };
    }
}

