/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.auth;

import com.google.gson.JsonObject;
import com.pingan.iobs.sdk.auth.AuthException;
import com.pingan.iobs.sdk.auth.DigestAuth;
import com.pingan.iobs.sdk.auth.EncodeUtil;
import com.pingan.iobs.sdk.auth.Mac;

public class PutPolicy {
    public String scope;
    public String callbackUrl;
    public String callbackBody;
    public String returnUrl;
    public String returnBody;
    public String endUser;
    public long expires;
    public String saveKey;
    public int insertOnly;
    public int detectMime;
    public long fsizeLimit;
    public String mimeLimit;
    public String persistentNotifyUrl;
    public String persistentOps;
    public long deadline;
    public String persistentPipeline;

    public PutPolicy() {
    }

    public PutPolicy(String scope) {
        this.scope = scope;
    }

    public String marshal() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("scope", this.scope);
        if (this.callbackUrl != null && this.callbackUrl.length() > 0) {
            jsonObject.addProperty("callbackUrl", this.callbackUrl);
        }
        if (this.callbackBody != null && this.callbackBody.length() > 0) {
            jsonObject.addProperty("callbackBody", this.callbackBody);
        }
        if (this.returnUrl != null && this.returnUrl.length() > 0) {
            jsonObject.addProperty("returnUrl", this.returnUrl);
        }
        if (this.returnBody != null && this.returnBody.length() > 0) {
            jsonObject.addProperty("returnBody", this.returnBody);
        }
        if (this.saveKey != null && this.saveKey.length() > 0) {
            jsonObject.addProperty("saveKey", this.saveKey);
        }
        if (this.insertOnly > 0) {
            jsonObject.addProperty("insertOnly", (Number)this.insertOnly);
        }
        if (this.detectMime > 0) {
            jsonObject.addProperty("detectMime", (Number)this.detectMime);
        }
        if (this.fsizeLimit > 0L) {
            jsonObject.addProperty("fsizeLimit", (Number)this.fsizeLimit);
        }
        if (this.mimeLimit != null && this.mimeLimit.length() > 0) {
            jsonObject.addProperty("mimeLimit", this.mimeLimit);
        }
        if (this.endUser != null && this.endUser.length() > 0) {
            jsonObject.addProperty("endUser", this.endUser);
        }
        if (this.persistentNotifyUrl != null && this.persistentNotifyUrl.length() > 0) {
            jsonObject.addProperty("persistentNotifyUrl", this.persistentNotifyUrl);
        }
        if (this.persistentOps != null && this.persistentOps.length() > 0) {
            jsonObject.addProperty("persistentOps", this.persistentOps);
        }
        if (this.persistentPipeline != null && this.persistentPipeline.trim().length() > 0) {
            jsonObject.addProperty("persistentPipeline", this.persistentPipeline);
        }
        jsonObject.addProperty("deadline", (Number)this.deadline);
        return jsonObject.toString();
    }

    public String token(Mac mac, boolean isSdk) throws AuthException {
        if (this.expires <= 0L || this.expires >= 900L) {
            this.expires = 900L;
        }
        long deadline = System.currentTimeMillis() / 1000L + this.expires;
        if (this.deadline <= 0L || this.deadline >= deadline) {
            this.deadline = deadline;
        }
        byte[] data = EncodeUtil.toByte(this.marshal());
        if (isSdk) {
            return DigestAuth.signWithDataBySdk(mac, data);
        }
        return DigestAuth.signWithData(mac, data);
    }

    public String token(Mac mac) throws AuthException {
        return this.token(mac, true);
    }
}

