/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.facepp.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class HttpUtils {
    private static final MediaType MediaType_APPLICATION = MediaType.parse("application/octet-stream");
    private static final String KEY_IMAGE_FILE = "image_file";
    public static final String KEY_IMAGE_FILE_1 = "image_file1";
    public static final String KEY_IMAGE_FILE_2 = "image_file2";
    public static final String KEY_TEMPLATE_FILE = "template_file";
    public static final String KEY_MERGE_FILE = "merge_file";
    private static OkHttpClient okHttpClient;

    public static void post(String url, Map<String, String> params, Callback callback) {
        HttpUtils.post(url, params, new byte[0], callback);
    }

    public static void post(String url, Map<String, String> params, byte[] file, Callback callback) {
        HashMap<String, byte[]> fileParams = new HashMap<String, byte[]>();
        fileParams.put(KEY_IMAGE_FILE, file);
        HttpUtils.post(url, params, fileParams, null, callback);
    }

    public static void post(String url, Map<String, String> params, Map<String, byte[]> file, Callback callback) {
        HttpUtils.post(url, params, file, null, callback);
    }

    public static void post(String url, Map<String, String> params, Map<String, byte[]> file1, Map<String, byte[]> file2, Callback callback) {
        block2: {
            try {
                RequestBody requestBody = HttpUtils.buildRequestBody(params, file1, file2);
                HttpUtils.doPost(new Request.Builder().url(url).post(requestBody).build(), callback);
            }
            catch (Exception e) {
                if (null == callback) break block2;
                callback.onFailure(null, new IOException(e.getMessage()));
            }
        }
    }

    private static RequestBody buildRequestBody(Map<String, String> params, Map<String, byte[]> filePath1, Map<String, byte[]> filePath2) throws Exception {
        MultipartBody.Builder bodyBuilder = HttpUtils.addNormalParams(params);
        HttpUtils.addFileParamsByKey(filePath1, bodyBuilder);
        HttpUtils.addFileParamsByKey(filePath2, bodyBuilder);
        return bodyBuilder.build();
    }

    private static MultipartBody.Builder addNormalParams(Map<String, String> params) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (String key : params.keySet()) {
            String value = params.get(key);
            bodyBuilder.addFormDataPart(key, value);
        }
        return bodyBuilder;
    }

    private static void doPost(Request request, Callback callback) {
        if (null == okHttpClient) {
            okHttpClient = new OkHttpClient();
        }
        okHttpClient.newCall(request).enqueue(callback);
    }

    private static void addFileParams(MultipartBody.Builder bodyBuilder, String key, byte[] file) throws Exception {
        bodyBuilder.addFormDataPart(key, key, RequestBody.create(MediaType_APPLICATION, file));
    }

    private static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    private static void addFileParamsByKey(Map<String, byte[]> filePath, MultipartBody.Builder bodyBuilder) throws Exception {
        if (null != filePath) {
            HttpUtils.getDataByKey(filePath, KEY_IMAGE_FILE, bodyBuilder);
            HttpUtils.getDataByKey(filePath, KEY_IMAGE_FILE_1, bodyBuilder);
            HttpUtils.getDataByKey(filePath, KEY_IMAGE_FILE_2, bodyBuilder);
            HttpUtils.getDataByKey(filePath, KEY_TEMPLATE_FILE, bodyBuilder);
            HttpUtils.getDataByKey(filePath, KEY_MERGE_FILE, bodyBuilder);
        }
    }

    private static void getDataByKey(Map<String, byte[]> file, String key, MultipartBody.Builder bodyBuilder) throws Exception {
        if (!HttpUtils.isEmpty(file.get(key))) {
            HttpUtils.addFileParams(bodyBuilder, key, file.get(key));
        }
    }
}

