/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;

public class JSONObject {
    private static final String STRING_COLON_SPACE = ": ";
    private static final String STRING_COMMA_TRANSFER_N = ",\n";
    private static final String STRING_BIGBRACKET = "{}";
    private static final String STRING_LEFTBIGBRACKET = "{";
    private static final String STRING_TRANSFER_U = "\\u";
    private static final String STRING_THREEZERO = "000";
    private static final char CHAR_U2100 = '\u2100';
    private static final char CHAR_U2000 = '\u2000';
    private static final char CHAR_U00A0 = '\u00a0';
    private static final char CHAR_U0080 = '\u0080';
    private static final char CHAR_SPACE = ' ';
    private static final String STRING_TRANSFER_R = "\\r";
    private static final char CHAR_TRANSFER_R = '\r';
    private static final String STRING_TRANSFER_F = "\\f";
    private static final char CHAR_TRANSFER_F = '\f';
    private static final String STRING_TRANSFER_N = "\\n";
    private static final char CHAR_TRANSFER_N = '\n';
    private static final String STRING_TRANSFER_T = "\\t";
    private static final char CHAR_TRANSFER_T = '\t';
    private static final String STRING_TRANSFER_B = "\\b";
    private static final char CHAR_TRANSFER_B = '\b';
    private static final char CHAR_DIAGONAL = '/';
    private static final char CHAR_REVERSEDIAGONAL = '\\';
    private static final char CHAR_QUOTE = '\"';
    private static final String STRING_DOUBLEQUOTE = "\"\"";
    private static final String STRING_TRUE = "true";
    private static final String STRING_FALSE = "false";
    private static final String STRING_FULLSTOP = ".";
    private static final String STRING_ZERO = "0";
    private static final char CHAR_UPPERCASE_E = 'E';
    private static final char CHAR_LOWCASE_E = 'e';
    private static final char CHAR_FULLSTOP = '.';
    private static final String STRING_JAVA = "java";
    private static final String STRING_IS = "is";
    private static final String STRING_GET = "get";
    private static final String STRING_EMPTY = "";
    private static final char CHAR_COMMA = ',';
    private static final char CHAR_SEMICOLON = ';';
    private static final char CHAR_COLON = ':';
    private static final char CHAR_BIGGERTHAN = '>';
    private static final char CHAR_EQUAL = '=';
    private static final char CHAR_RIGHTBIGBRACKET = '}';
    private static final char CHAR_LEFTBIGBRACKET = '{';
    private Map map;
    public static final Object NULL = new Null();
    private static final String STRING_NULL = "null";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public JSONObject() {
        this.map = new HashMap();
    }

    public JSONObject(JSONObject jo, String[] names) throws JSONException {
        this();
        int i = 0;
        while (i < names.length) {
            this.putOpt(names[i], jo.opt(names[i]));
            ++i;
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.put(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map) {
        this.map = map == null ? new HashMap() : map;
    }

    public JSONObject(Map map, boolean includeSuperClass) {
        this.map = new HashMap();
        if (map != null) {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                this.map.put(e.getKey(), new JSONObject(e.getValue(), includeSuperClass));
            }
        }
    }

    public JSONObject(Object bean) {
        this();
        this.populateInternalMap(bean, false);
    }

    public JSONObject(Object bean, boolean includeSuperClass) {
        this();
        this.populateInternalMap(bean, includeSuperClass);
    }

    private void populateInternalMap(Object bean, boolean includeSuperClass) {
        Class<?> klass = bean.getClass();
        if (klass.getClassLoader() == null) {
            includeSuperClass = false;
        }
        Method[] methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            try {
                Method method = methods[i];
                String name = method.getName();
                String key = STRING_EMPTY;
                if (name.startsWith(STRING_GET)) {
                    key = name.substring(3);
                } else if (name.startsWith(STRING_IS)) {
                    key = name.substring(2);
                }
                if (key.length() > 0 && Character.isUpperCase(key.charAt(0)) && method.getParameterTypes().length == 0) {
                    if (key.length() == 1) {
                        key = key.toLowerCase();
                    } else if (!Character.isUpperCase(key.charAt(1))) {
                        key = String.valueOf(key.substring(0, 1).toLowerCase()) + key.substring(1);
                    }
                    Object result = method.invoke(bean, null);
                    if (result == null) {
                        this.map.put(key, NULL);
                    } else if (result.getClass().isArray()) {
                        this.map.put(key, new JSONArray(result, includeSuperClass));
                    } else if (result instanceof Collection) {
                        this.map.put(key, new JSONArray((Collection)result, includeSuperClass));
                    } else if (result instanceof Map) {
                        this.map.put(key, new JSONObject((Map)result, includeSuperClass));
                    } else if (this.isStandardProperty(result.getClass())) {
                        this.map.put(key, result);
                    } else if (result.getClass().getPackage().getName().startsWith(STRING_JAVA) || result.getClass().getClassLoader() == null) {
                        this.map.put(key, result.toString());
                    } else {
                        this.map.put(key, new JSONObject(result, includeSuperClass));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
    }

    private boolean isStandardProperty(Class clazz) {
        if (!clazz.isPrimitive()) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(clazz2)) {
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(clazz3)) {
                    Class<?> clazz4 = class$2;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$2 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz.isAssignableFrom(clazz4)) {
                        Class<?> clazz5 = class$3;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$3 = Class.forName("java.lang.Long");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!clazz.isAssignableFrom(clazz5)) {
                            Class<?> clazz6 = class$4;
                            if (clazz6 == null) {
                                try {
                                    clazz6 = class$4 = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (!clazz.isAssignableFrom(clazz6)) {
                                Class<?> clazz7 = class$5;
                                if (clazz7 == null) {
                                    try {
                                        clazz7 = class$5 = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (!clazz.isAssignableFrom(clazz7)) {
                                    Class<?> clazz8 = class$6;
                                    if (clazz8 == null) {
                                        try {
                                            clazz8 = class$6 = Class.forName("java.lang.Character");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (!clazz.isAssignableFrom(clazz8)) {
                                        Class<?> clazz9 = class$7;
                                        if (clazz9 == null) {
                                            try {
                                                clazz9 = class$7 = Class.forName("java.lang.String");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (!clazz.isAssignableFrom(clazz9)) {
                                            Class<?> clazz10 = class$8;
                                            if (clazz10 == null) {
                                                try {
                                                    clazz10 = class$8 = Class.forName("java.lang.Boolean");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (!clazz.isAssignableFrom(clazz10)) {
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    public JSONObject(Object object, String[] names) {
        this();
        Class<?> c = object.getClass();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            try {
                Field field = c.getField(name);
                Object value = field.get(object);
                this.put(name, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public JSONObject(String source) throws JSONException {
        this(new JSONTokener(source));
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (o instanceof JSONArray) {
            ((JSONArray)o).put(value);
        } else {
            this.put(key, new JSONArray().put(o).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, new JSONArray().put(value));
        } else if (o instanceof JSONArray) {
            this.put(key, ((JSONArray)o).put(value));
        } else {
            throw new JSONException("JSONObject[" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return STRING_NULL;
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith(STRING_ZERO)) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(STRING_FULLSTOP)) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object get(String key) throws JSONException {
        Object o = this.opt(key);
        if (o == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws JSONException {
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase(STRING_FALSE)) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase(STRING_TRUE)) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws JSONException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) throws JSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) throws JSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    public static String[] getNames(JSONObject jo) {
        int length = jo.length();
        if (length == 0) {
            return null;
        }
        Iterator i = jo.keys();
        String[] names = new String[length];
        int j = 0;
        while (i.hasNext()) {
            names[j] = (String)i.next();
            ++j;
        }
        return names;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        int i = 0;
        while (i < length) {
            names[i] = fields[i].getName();
            ++i;
        }
        return names;
    }

    public String getString(String key) throws JSONException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String numberToString(Number n) throws JSONException {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith(STRING_ZERO)) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(STRING_FULLSTOP)) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object opt(String key) {
        return key == null ? null : this.map.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONObject put(String key, Collection value) throws JSONException {
        this.put(key, new JSONArray(value));
        return this;
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, STRING_EMPTY);
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.put(key, new Double(value));
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.put(key, new Integer(value));
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.put(key, new Long(value));
        return this;
    }

    public JSONObject put(String key, Map value) throws JSONException {
        this.put(key, new JSONObject(value));
        return this;
    }

    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.map.put(key, value);
        } else {
            this.map.put(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return STRING_DOUBLEQUOTE;
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '/': {
                    if (b == '>') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    break;
                }
                case '\b': {
                    sb.append(STRING_TRANSFER_B);
                    break;
                }
                case '\t': {
                    sb.append(STRING_TRANSFER_T);
                    break;
                }
                case '\n': {
                    sb.append(STRING_TRANSFER_N);
                    break;
                }
                case '\f': {
                    sb.append(STRING_TRANSFER_F);
                    break;
                }
                case '\r': {
                    sb.append(STRING_TRANSFER_R);
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = STRING_THREEZERO + Integer.toHexString(c);
                        sb.append(STRING_TRANSFER_U + t.substring(t.length() - 4));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public Iterator sortedKeys() {
        return new TreeSet(this.map.keySet()).iterator();
    }

    static void testValidity(Object o) throws JSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        int i = 0;
        while (i < names.length()) {
            ja.put(this.opt(names.getString(i)));
            ++i;
        }
        return ja;
    }

    public String toString() {
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer(STRING_LEFTBIGBRACKET);
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONObject.quote(o.toString()));
                sb.append(':');
                sb.append(JSONObject.valueToString(this.map.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    /*
     * Unable to fully structure code
     */
    String toString(int indentFactor, int indent) throws JSONException {
        block7: {
            n = this.length();
            if (n == 0) {
                return "{}";
            }
            keys = this.sortedKeys();
            sb = new StringBuffer("{");
            newindent = indent + indentFactor;
            if (n != 1) ** GOTO lbl35
            o = keys.next();
            sb.append(JSONObject.quote(o.toString()));
            sb.append(": ");
            sb.append(JSONObject.valueToString(this.map.get(o), indentFactor, indent));
            break block7;
lbl-1000:
            // 1 sources

            {
                o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                j = 0;
                while (j < newindent) {
                    sb.append(' ');
                    ++j;
                }
                sb.append(JSONObject.quote(o.toString()));
                sb.append(": ");
                sb.append(JSONObject.valueToString(this.map.get(o), indentFactor, newindent));
lbl35:
                // 2 sources

                ** while (keys.hasNext())
            }
lbl36:
            // 1 sources

            if (sb.length() > 1) {
                sb.append('\n');
                j = 0;
                while (j < indent) {
                    sb.append(' ');
                    ++j;
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return STRING_NULL;
        }
        if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONObject.quote(value.toString());
    }

    static String valueToString(Object value, int indentFactor, int indent) throws JSONException {
        if (value == null || value.equals(null)) {
            return STRING_NULL;
        }
        try {
            String o;
            if (value instanceof JSONString && (o = ((JSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString(indentFactor, indent);
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString(indentFactor, indent);
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString(indentFactor, indent);
        }
        return JSONObject.quote(value.toString());
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean b = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.next();
                writer.write(JSONObject.quote(k.toString()));
                writer.write(58);
                Object v = this.map.get(k);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private static final class Null {
        private static final String STRING_NULL = "null";

        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

