/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.crypto.utils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Properties;

public class RSA {
    public static boolean icbcRsaGenkey(int n) throws Exception {
        return RSA.icbcRsaGenkey(n, "", "");
    }

    public static boolean icbcRsaGenkey(int n, String string, String string2) throws Exception {
        if (n % 512 != 0) {
            throw new Exception("\u5bc6\u94a5\u957f\u5ea6\u4e0d\u5bf9\uff0c\u5fc5\u987b\u4e3a512\u7684\u6574\u6570\u500d\uff01");
        }
        KeyPairGenerator keyPairGenerator = null;
        keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        System.out.println("\u6b63\u5728\u521d\u59cb\u5316\u5bc6\u94a5\u957f\u5ea6\u4e3a" + n + "\u7684\u5bc6\u94a5\u751f\u6210\u5668......");
        keyPairGenerator.initialize(n);
        System.out.println("\u6b63\u5728\u751f\u6210\u5bc6\u94a5\u5bf9......");
        KeyPair keyPair = null;
        RSAPublicKey rSAPublicKey = null;
        RSAPrivateKey rSAPrivateKey = null;
        long l = System.currentTimeMillis();
        while (true) {
            keyPair = keyPairGenerator.generateKeyPair();
            rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
            rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
            if (rSAPublicKey.getModulus().bitLength() == n) break;
            if (System.currentTimeMillis() - l > 60000L) {
                throw new Exception("\u5728\u4e00\u5206\u949f\u5185\u6ca1\u6709\u83b7\u53d6\u5230\u7b26\u5408\u8981\u6c42\u7684\u5bc6\u94a5\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u5bc6\u94a5\uff01");
            }
            System.out.println("\u5df2\u7ecf\u751f\u6210\u4e86\u5bc6\u94a5\uff0c\u4f46\u662f\u4e0d\u7b26\u5408\u5de5\u884c\u7684\u5b89\u5168\u8981\u6c42\uff0c\u7ee7\u7eed\u751f\u6210\u4e0b\u4e00\u4e2a\u5bc6\u94a5\uff01");
        }
        System.out.println("\u6210\u529f\u751f\u6210\u5bc6\u94a5\uff01");
        String string3 = "Skey_RSA_pub.key";
        FileOutputStream fileOutputStream = null;
        if (string != null && string.trim().length() != 0) {
            string3 = string;
        }
        fileOutputStream = new FileOutputStream(string3);
        fileOutputStream.write(rSAPublicKey.getEncoded());
        System.out.println("\u5c06\u516c\u94a5\u5199\u5165" + string3 + "\u6587\u4ef6\u6210\u529f\uff01");
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string4 = "Skey_RSA_priv.key";
        FileOutputStream fileOutputStream2 = null;
        if (string2 != null && string2.trim().length() != 0) {
            string4 = string2;
        }
        fileOutputStream2 = new FileOutputStream(string4);
        fileOutputStream2.write(rSAPrivateKey.getEncoded());
        System.out.println("\u5c06\u79c1\u94a5\u5199\u5165" + string4 + "\u6587\u4ef6\u6210\u529f!");
        try {
            fileOutputStream2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static byte[] icbcRsaPubEn(byte[] byArray) throws Exception {
        return RSA.icbcRsaPubEn(byArray, "");
    }

    public static byte[] icbcRsaPubEn(byte[] byArray, String string) throws Exception {
        String string2 = "Skey_RSA_pub.key";
        RSAPublicKey rSAPublicKey = null;
        FileInputStream fileInputStream = null;
        if (string != null && string.trim().length() != 0) {
            string2 = string;
        }
        fileInputStream = new FileInputStream(string2);
        byte[] byArray2 = new byte[fileInputStream.available()];
        fileInputStream.read(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BigInteger bigInteger = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        int n = byArray.length;
        if (n > (bigInteger2.bitLength() + 7) / 8) {
            throw new Exception("\u4e00\u6b21\u4e0d\u80fd\u52a0\u5bc6\u6e90\u957f\u5ea6\u8d85\u8fc7" + (bigInteger2.bitLength() + 7) / 8 + "\u7684\u6570\u636e");
        }
        byte[] byArray3 = new byte[(bigInteger2.bitLength() + 7) / 8];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        Arrays.fill(byArray3, n, byArray3.length, (byte)0);
        BigInteger bigInteger3 = new BigInteger(byArray3);
        System.out.println("\u4f7f\u7528\u516c\u94a5\u52a0\u5bc6\u660e\u6587......");
        byte[] byArray4 = bigInteger3.modPow(bigInteger, bigInteger2).toByteArray();
        System.out.println("\u52a0\u5bc6\u660e\u6587\u6210\u529f\uff01");
        if (byArray4.length > byArray3.length && byArray4[0] == 0) {
            System.arraycopy(byArray4, 1, byArray3, 0, byArray3.length);
            return byArray3;
        }
        return byArray4;
    }

    public static byte[] icbcRsaPriEn(byte[] byArray) throws Exception {
        return RSA.icbcRsaPriEn(byArray, "");
    }

    public static byte[] icbcRsaPriEn(byte[] byArray, String string) throws Exception {
        String string2 = "Skey_RSA_priv.key";
        RSAPrivateKey rSAPrivateKey = null;
        FileInputStream fileInputStream = null;
        if (string != null && string.trim().length() != 0) {
            string2 = string;
        }
        fileInputStream = new FileInputStream(string2);
        byte[] byArray2 = new byte[fileInputStream.available()];
        fileInputStream.read(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
        rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BigInteger bigInteger = rSAPrivateKey.getPrivateExponent();
        BigInteger bigInteger2 = rSAPrivateKey.getModulus();
        int n = byArray.length;
        if (n > (bigInteger2.bitLength() + 7) / 8) {
            throw new Exception("\u4e00\u6b21\u4e0d\u80fd\u52a0\u5bc6\u6e90\u957f\u5ea6\u8d85\u8fc7" + (bigInteger2.bitLength() + 7) / 8 + "\u7684\u6570\u636e");
        }
        byte[] byArray3 = new byte[(bigInteger2.bitLength() + 7) / 8];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        Arrays.fill(byArray3, n, byArray3.length, (byte)0);
        BigInteger bigInteger3 = new BigInteger(byArray3);
        System.out.println("\u4f7f\u7528\u79c1\u94a5\u52a0\u5bc6\u660e\u6587......");
        byte[] byArray4 = bigInteger3.modPow(bigInteger, bigInteger2).toByteArray();
        System.out.println("\u52a0\u5bc6\u660e\u6587\u6210\u529f\uff01");
        if (byArray4.length > byArray3.length && byArray4[0] == 0) {
            System.arraycopy(byArray4, 1, byArray3, 0, byArray3.length);
            return byArray3;
        }
        return byArray4;
    }

    public static byte[] icbcRsaPriDe(byte[] byArray) throws Exception {
        return RSA.icbcRsaPriDe(byArray, "");
    }

    public static byte[] icbcRsaPriDe(byte[] byArray, String string) throws Exception {
        byte[] byArray2 = null;
        BigInteger bigInteger = null;
        byte by = byArray[0];
        if (by < 0) {
            byArray2 = new byte[byArray.length + 1];
            byArray2[0] = 0;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            bigInteger = new BigInteger(byArray2);
        } else {
            bigInteger = new BigInteger(byArray);
        }
        String string2 = "Skey_RSA_priv.key";
        RSAPrivateKey rSAPrivateKey = null;
        FileInputStream fileInputStream = null;
        if (string != null && string.trim().length() != 0) {
            string2 = string;
        }
        fileInputStream = new FileInputStream(string2);
        byte[] byArray3 = new byte[fileInputStream.available()];
        fileInputStream.read(byArray3);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray3);
        rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BigInteger bigInteger2 = rSAPrivateKey.getPrivateExponent();
        BigInteger bigInteger3 = rSAPrivateKey.getModulus();
        System.out.println("\u4f7f\u7528\u79c1\u94a5\u89e3\u5bc6\u5bc6\u6587......");
        BigInteger bigInteger4 = bigInteger.modPow(bigInteger2, bigInteger3);
        byte[] byArray4 = bigInteger4.toByteArray();
        int n = byArray4.length;
        for (int i = 0; i < byArray4.length; ++i) {
            if (byArray4[i] != 0) continue;
            n = i;
            break;
        }
        byte[] byArray5 = new byte[n];
        System.arraycopy(byArray4, 0, byArray5, 0, n);
        System.out.println("\u89e3\u5bc6\u6210\u529f\uff01");
        return byArray5;
    }

    public static byte[] icbcRsaPubDe(byte[] byArray) throws Exception {
        return RSA.icbcRsaPubDe(byArray, "");
    }

    public static byte[] icbcRsaPubDe(byte[] byArray, String string) throws Exception {
        byte[] byArray2 = null;
        BigInteger bigInteger = null;
        byte by = byArray[0];
        if (by < 0) {
            byArray2 = new byte[byArray.length + 1];
            byArray2[0] = 0;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            bigInteger = new BigInteger(byArray2);
        } else {
            bigInteger = new BigInteger(byArray);
        }
        String string2 = "Skey_RSA_pub.key";
        RSAPublicKey rSAPublicKey = null;
        FileInputStream fileInputStream = null;
        if (string != null && string.trim().length() != 0) {
            string2 = string;
        }
        fileInputStream = new FileInputStream(string2);
        byte[] byArray3 = new byte[fileInputStream.available()];
        fileInputStream.read(byArray3);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray3);
        rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger3 = rSAPublicKey.getModulus();
        System.out.println("\u4f7f\u7528\u516c\u94a5\u89e3\u5bc6\u5bc6\u6587......");
        BigInteger bigInteger4 = bigInteger.modPow(bigInteger2, bigInteger3);
        byte[] byArray4 = bigInteger4.toByteArray();
        int n = byArray4.length;
        for (int i = 0; i < byArray4.length; ++i) {
            if (byArray4[i] != 0) continue;
            n = i;
            break;
        }
        byte[] byArray5 = new byte[n];
        System.arraycopy(byArray4, 0, byArray5, 0, n);
        System.out.println("\u89e3\u5bc6\u6210\u529f\uff01");
        return byArray5;
    }

    public static boolean convertX509PublicKeyToOpenSSL(String string, String string2) throws Exception {
        System.out.println("\u5c06X509\u683c\u5f0f\u7684\u516c\u94a5\u8f6c\u6362\u4e3aOpenSSL\u683c\u5f0f\u7684\u516c\u94a5\u5f00\u59cb\uff01");
        RSAPublicKey rSAPublicKey = null;
        FileInputStream fileInputStream = null;
        if (string == null || string.trim().length() == 0) {
            throw new Exception("\u8f93\u5165\u53c2\u6570" + string + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new Exception("\u8f93\u5165\u53c2\u6570" + string2 + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("\u6b63\u5728\u4ece" + string + "\u4e2d\u8bfb\u53d6X509\u683c\u5f0f\u7684\u516c\u94a5\u3002\u3002\u3002");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        BigInteger bigInteger = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        System.out.println("\u4ece" + string + "\u6587\u4ef6\u4e2d\u6062\u590d\u516c\u94a5\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u884c\u8f6c\u6362\u3002\u3002\u3002");
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(string2);
        fileOutputStream.write("N=".getBytes());
        fileOutputStream.write(bigInteger2.toString(16).getBytes());
        fileOutputStream.write("\r\nE=".getBytes());
        fileOutputStream.write(bigInteger.toString(16).getBytes());
        try {
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("\u8f6c\u6362\u6210OpenSSL\u683c\u5f0f\u7684\u516c\u94a5\u6210\u529f\uff0c\u516c\u94a5\u5b58\u653e\u5728" + string2 + "\u6587\u4ef6\u4e2d!");
        return true;
    }

    public static boolean convertOpenSSLPublicKeyToX509(String string, String string2) throws Exception {
        System.out.println("\u5c06OpenSSL\u683c\u5f0f\u7684\u516c\u94a5\u8f6c\u6362\u4e3aX509\u683c\u5f0f\u7684\u516c\u94a5\u5f00\u59cb\uff01");
        Properties properties = new Properties();
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        if (string2 == null || string2.trim().length() == 0) {
            throw new Exception("\u8f93\u5165\u53c2\u6570" + string2 + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (string == null || string.trim().length() == 0) {
            throw new Exception("\u8f93\u5165\u53c2\u6570" + string + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        System.out.println("\u6b63\u5728\u4ece" + string + "\u4e2d\u8bfb\u53d6OpenSSL\u683c\u5f0f\u7684\u516c\u94a5\u3002\u3002\u3002");
        fileInputStream = new FileInputStream(string);
        properties.load(fileInputStream);
        String string3 = properties.getProperty("N");
        String string4 = properties.getProperty("E");
        System.out.println("\u4ece" + string + "\u6587\u4ef6\u4e2d\u6062\u590d\u516c\u94a5\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u884c\u8f6c\u6362\u3002\u3002\u3002");
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(string3, 16), new BigInteger(string4, 16));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
        fileOutputStream = new FileOutputStream(string2);
        fileOutputStream.write(publicKey.getEncoded());
        try {
            fileOutputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("\u8f6c\u6362\u6210X509\u683c\u5f0f\u7684\u516c\u94a5\u6210\u529f\uff0c\u516c\u94a5\u5b58\u653e\u5728" + string2 + "\u6587\u4ef6\u4e2d!");
        return true;
    }

    private static void _$1() {
        System.out.println("\u53c2\u6570\u9519\u8bef\u3002");
        System.out.println("\u7528\u6cd51\uff1a-create Keylen PubKeyFileName PriKeyFileName");
        System.out.println("\u7528\u4e8e\u4ea7\u751fx509\u7684\u79c1\u94a5\u4e0eopenssl\u7684\u516c\u94a5");
        System.out.println("\u7528\u6cd52\uff1a-toOpenSSL x509Filename opensslFilename");
        System.out.println("\u7528\u4e8e\u8f6c\u6362x509\u683c\u5f0f\u7684\u516c\u94a5\u4e3aopenssl\u683c\u5f0f");
        System.out.println("\u7528\u6cd53\uff1a-toX509 opensslFilenameX509Filename ");
        System.out.println("\u7528\u4e8e\u8f6c\u6362openssl\u683c\u5f0f\u7684\u516c\u94a5\u4e3ax509\u683c\u5f0f");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 4 && stringArray[0].equals("-create")) {
            int n = 1024;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                RSA._$1();
                return;
            }
            RSA.icbcRsaGenkey(n, stringArray[2], stringArray[3]);
            System.out.println("\u4ea7\u751f\u5bc6\u94a5\u5bf9\u6210\u529f");
        } else if (stringArray.length == 3) {
            if (stringArray[0].equals("-toOpenSSL")) {
                RSA.convertX509PublicKeyToOpenSSL(stringArray[1], stringArray[2]);
            } else if (stringArray[0].equals("-toX509")) {
                RSA.convertOpenSSLPublicKeyToX509(stringArray[1], stringArray[2]);
            } else {
                RSA._$1();
            }
        } else {
            RSA._$1();
        }
    }
}

