/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.utils;

import com.icbc.api.IcbcApiException;
import com.icbc.api.crypt.IcbcCa;
import com.icbc.api.crypt.RSA;
import com.icbc.api.internal.util.codec.Base64;
import com.icbc.hsm.software.apiLib.Signature;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.external.ClearKeyFunction;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IcbcSignature {
    private static final Log logger = LogFactory.getLog(IcbcSignature.class);

    public static String sign(String content, String signType, String privateKey, String charset) throws IcbcApiException {
        return IcbcSignature.sign(content, signType, privateKey, charset, null);
    }

    public static String sign(String content, String signType, String privateKey, String charset, String password) throws IcbcApiException {
        try {
            byte[] contentBytes = content.getBytes(charset);
            if (signType.equals("CA")) {
                return IcbcCa.sign(contentBytes, privateKey, password);
            }
            if (signType.equals("RSA")) {
                return RSA.sign(contentBytes, Base64.decodeBase64(privateKey), "SHA1WithRSA");
            }
            if (signType.equals("RSA2")) {
                return RSA.sign(contentBytes, Base64.decodeBase64(privateKey), "SHA256WithRSA");
            }
            if (signType.equals("SM2")) {
                ClearKeyParameter privateKeySM2 = ClearKeyFunction.loadClear((String)privateKey, (String)"SM2private");
                byte[] sigSrcData = content.getBytes(charset);
                Signature dv = Signature.getInstance((String)"SM3WITHSM2");
                byte[] signature = dv.sign((HsmKeyParameter)privateKeySM2, sigSrcData);
                return com.icbc.hsm.utils.encoders.Base64.toBase64String((byte[])signature);
            }
            logger.error((Object)"not support signType.");
            throw new IcbcApiException("not support signType.");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("get content charset exception. content: " + content + " charset: " + charset), (Throwable)e);
            throw new IcbcApiException("get content charset exception. content: " + content + " charset: " + charset, e);
        }
        catch (Exception e) {
            logger.error((Object)"sign exception.", (Throwable)e);
            throw new IcbcApiException("sign exception.", e);
        }
    }

    public static boolean verify(String content, String signType, String publicKey, String charset, String sign) throws IcbcApiException {
        try {
            byte[] contentBytes = content.getBytes(charset);
            if (signType.equals("CA")) {
                return IcbcCa.verify(contentBytes, publicKey, sign);
            }
            if (signType.equals("RSA")) {
                return RSA.verify(contentBytes, Base64.decodeBase64(publicKey), sign, "SHA1WithRSA");
            }
            if (signType.equals("RSA2")) {
                return RSA.verify(contentBytes, Base64.decodeBase64(publicKey), sign, "SHA256WithRSA");
            }
            if (signType.equals("SM2")) {
                byte[] signature_server = com.icbc.hsm.utils.encoders.Base64.decode((String)sign);
                ClearKeyParameter privateKey_icbc = ClearKeyFunction.loadClear((String)publicKey, (String)"SM2public");
                Signature dv = Signature.getInstance((String)"SM3WITHSM2");
                return dv.verify((HsmKeyParameter)privateKey_icbc, content.getBytes(charset), signature_server);
            }
            logger.error((Object)"not support signType.");
            throw new IcbcApiException("not support signType.");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("get content charset exception. content: " + content + " charset: " + charset), (Throwable)e);
            throw new IcbcApiException("get content charset exception. content: " + content + " charset: " + charset, e);
        }
        catch (Exception e) {
            logger.error((Object)"sign verify exception.", (Throwable)e);
            throw new IcbcApiException("sign verify exception.", e);
        }
    }
}

