/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.utils;

import com.icbc.api.IcbcApiException;
import com.icbc.api.crypt.AES;
import com.icbc.hsm.software.apiLib.Cipher;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.external.ClearKeyFunction;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.utils.encoders.Base64;

public class IcbcEncrypt {
    private static final String AES_ALG = "AES";
    private static final String SM4 = "SM4";

    public static String encryptContent(String content, String encryptType, String encryptKey, String charset) throws IcbcApiException {
        if (AES_ALG.equals(encryptType)) {
            return AES.aesEncrypt(content, encryptKey, charset);
        }
        if (SM4.equals(encryptType)) {
            try {
                ClearKeyParameter dek = ClearKeyFunction.loadClear((String)encryptKey, (String)encryptType);
                byte[] srcData = content.getBytes(charset);
                Cipher cd = Cipher.getInstance((String)encryptType, (String)"CBC", (String)"PKCS5PADDING");
                byte[] encrytedData = cd.encipher((HsmKeyParameter)dek, srcData);
                return Base64.toBase64String((byte[])encrytedData);
            }
            catch (Exception e) {
                throw new IcbcApiException("SM4\u52a0\u5bc6\u5931\u8d25\uff1acontent = " + content + "; charset = " + charset, e);
            }
        }
        throw new IcbcApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aencrypeType=" + encryptType);
    }

    public static String decryptContent(String content, String encryptType, String encryptKey, String charset) throws IcbcApiException {
        if (AES_ALG.equals(encryptType)) {
            return AES.aesDecrypt(content, encryptKey, charset);
        }
        if (SM4.equals(encryptType)) {
            try {
                ClearKeyParameter dek = ClearKeyFunction.loadClear((String)encryptKey, (String)encryptType);
                Cipher cd = Cipher.getInstance((String)encryptType, (String)"CBC", (String)"PKCS5PADDING");
                byte[] encryptedData = Base64.decode((String)content);
                byte[] decryptedData = cd.decipher((HsmKeyParameter)dek, encryptedData);
                return new String(decryptedData, charset);
            }
            catch (Exception e) {
                throw new IcbcApiException("SM4\u89e3\u5bc6\u5931\u8d25\uff1acontent = " + content + "; charset = " + charset, e);
            }
        }
        throw new IcbcApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aencrypeType=" + encryptType);
    }
}

