/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.impl.nio.reactor.ListenerEndpointClosedCallback;
import com.icbc.api.internal.apache.http.nio.reactor.ListenerEndpoint;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ListenerEndpointImpl
implements ListenerEndpoint {
    private volatile boolean completed;
    private volatile boolean closed;
    private volatile SelectionKey key;
    private volatile SocketAddress address;
    private volatile IOException exception;
    private final ListenerEndpointClosedCallback callback;

    public ListenerEndpointImpl(SocketAddress address, ListenerEndpointClosedCallback callback) {
        Args.notNull(address, "Address");
        this.address = address;
        this.callback = callback;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public IOException getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() throws InterruptedException {
        if (this.completed) {
            return;
        }
        ListenerEndpointImpl listenerEndpointImpl = this;
        synchronized (listenerEndpointImpl) {
            while (!this.completed) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(SocketAddress address) {
        Args.notNull(address, "Address");
        if (this.completed) {
            return;
        }
        this.completed = true;
        ListenerEndpointImpl listenerEndpointImpl = this;
        synchronized (listenerEndpointImpl) {
            this.address = address;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(IOException exception) {
        if (exception == null) {
            return;
        }
        if (this.completed) {
            return;
        }
        this.completed = true;
        ListenerEndpointImpl listenerEndpointImpl = this;
        synchronized (listenerEndpointImpl) {
            this.exception = exception;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.closed = true;
        ListenerEndpointImpl listenerEndpointImpl = this;
        synchronized (listenerEndpointImpl) {
            this.notifyAll();
        }
    }

    protected void setKey(SelectionKey key) {
        this.key = key;
    }

    public boolean isClosed() {
        return this.closed || this.key != null && !this.key.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        this.completed = true;
        this.closed = true;
        if (this.key != null) {
            this.key.cancel();
            SelectableChannel channel = this.key.channel();
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.callback != null) {
            this.callback.endpointClosed(this);
        }
        ListenerEndpointImpl listenerEndpointImpl = this;
        synchronized (listenerEndpointImpl) {
            this.notifyAll();
        }
    }
}

