/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.icbc.api.internal.apache.http.nio.client.HttpPipeliningClient;
import com.icbc.api.internal.apache.http.nio.client.methods.HttpAsyncMethods;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpPipeliningClient
extends CloseableHttpAsyncClient
implements HttpPipeliningClient {
    @Override
    public <T> Future<List<T>> execute(HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, FutureCallback<List<T>> callback) {
        return this.execute(target, requestProducers, responseConsumers, HttpClientContext.create(), callback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost target, List<HttpRequest> requests, FutureCallback<List<HttpResponse>> callback) {
        return this.execute(target, requests, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost target, List<HttpRequest> requests, HttpContext context, FutureCallback<List<HttpResponse>> callback) {
        Args.notEmpty(requests, "HTTP request list");
        ArrayList<HttpAsyncRequestProducer> requestProducers = new ArrayList<HttpAsyncRequestProducer>(requests.size());
        ArrayList<HttpAsyncResponseConsumer<HttpResponse>> responseConsumers = new ArrayList<HttpAsyncResponseConsumer<HttpResponse>>(requests.size());
        for (int i = 0; i < requests.size(); ++i) {
            HttpRequest request = requests.get(i);
            requestProducers.add(HttpAsyncMethods.create(target, request));
            responseConsumers.add(HttpAsyncMethods.createConsumer());
        }
        return this.execute(target, requestProducers, responseConsumers, context, callback);
    }
}

