/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.utils.encoders;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GF {
    public static byte[] bytesXor(byte[] xor1, byte[] xor2) {
        int len = xor1.length;
        byte[] ret = new byte[len];
        for (int i = 0; i < len && i < xor2.length; ++i) {
            ret[i] = (byte)(xor1[i] ^ xor2[i]);
        }
        return ret;
    }

    public static String C2XS(byte[] bMsg) {
        StringBuilder C2X_TMP = new StringBuilder();
        for (byte b : bMsg) {
            String one = String.format("%02X", b & 0xFF);
            C2X_TMP.append(one);
        }
        return C2X_TMP.toString();
    }

    public static byte[] X2CB(String strSource) {
        byte[] StrHex = strSource.getBytes();
        byte[] IntHex = new byte[StrHex.length / 2];
        GF.X2C(StrHex, IntHex);
        return IntHex;
    }

    public static String C2XS(String input, String encode) {
        String rtn;
        try {
            byte[] b = GF.isBlank(encode) ? input.getBytes() : input.getBytes(encode);
            rtn = GF.C2XS(b);
        }
        catch (UnsupportedEncodingException e) {
            rtn = "UnsupportedEncodingException";
            e.printStackTrace();
        }
        return rtn;
    }

    public static String X2CS(String strHex, String encode) {
        String rtn = "Error~!";
        if (GF.isBlank(strHex)) {
            return rtn;
        }
        int length = strHex.length();
        if (length % 2 != 0) {
            return rtn;
        }
        byte[] cha = new byte[length / 2];
        byte[] strByte = strHex.getBytes();
        if (GF.X2C(strByte, cha) >= 0) {
            try {
                rtn = GF.isBlank(encode) ? new String(cha) : new String(cha, encode);
            }
            catch (UnsupportedEncodingException e) {
                rtn = "UnsupportedEncodingException";
                e.printStackTrace();
            }
        }
        return rtn;
    }

    public static String removeBlankTabEnter(String str) {
        return str.replaceAll("\\s{1,}", "").replaceAll("\n", "").replaceAll("\t", "");
    }

    public static int X2C(byte[] hex, byte[] cha) {
        byte[] sh = hex;
        byte[] sb = cha;
        if (sh == null || sb == null) {
            return -20;
        }
        int n = sh.length;
        if (n < 2) {
            return -21;
        }
        if (n % 2 != 0) {
            return -22;
        }
        if (sb.length < n / 2) {
            return -23;
        }
        int i = 0;
        int j = 0;
        while (i < n) {
            int h2;
            int h1;
            if ((h1 = GF.hex_to_num(sh[i++])) < 0) {
                return -24;
            }
            if ((h2 = GF.hex_to_num(sh[i++])) < 0) {
                return -24;
            }
            int c1 = (h1 << 4 | h2) & 0xFF;
            sb[j] = (byte)c1;
            ++j;
        }
        return j;
    }

    private static int hex_to_num(byte hexchar) {
        if (hexchar >= 48 && hexchar <= 57) {
            return hexchar - 48;
        }
        if (hexchar >= 65 && hexchar <= 70) {
            return hexchar - 65 + 10;
        }
        if (hexchar >= 97 && hexchar <= 102) {
            return hexchar - 97 + 10;
        }
        return -1;
    }

    public static boolean isBlank(Object o) {
        boolean rtn = false;
        if ("".equals(o) || o == null) {
            rtn = true;
        }
        return rtn;
    }

    public static byte[] oddParity(byte[] in) {
        for (int i = 0; i < in.length; ++i) {
            int n = in[i];
            if (n < 0) {
                n = 256 + n;
            }
            String binary = Integer.toBinaryString(n);
            char[] array = binary.toCharArray();
            int count = 0;
            for (int j = 0; j < array.length; ++j) {
                if (array[j] != '1') continue;
                ++count;
            }
            if (count % 2 != 0) continue;
            char c = array[array.length - 1];
            array[array.length - 1] = c == '1' ? 48 : 49;
            binary = String.valueOf(array);
            in[i] = (byte)Integer.parseInt(binary, 2);
        }
        return in;
    }

    public static byte[] hexToByte(String data) throws Exception {
        byte[] ret = new byte[]{};
        int len = data.length();
        if (len % 2 != 0) {
            throw new Exception("\u6570\u636e\u4e0d\u662f2\u7684\u6574\u6570\u500d");
        }
        ret = new byte[len / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)Integer.parseInt(data.substring(i * 2, (i + 1) * 2), 16);
        }
        return ret;
    }

    public static byte[] XOR(String iv1, String iv2) throws Exception {
        if (iv1.length() != iv2.length()) {
            throw new Exception("two string length must be equal");
        }
        Pattern p = Pattern.compile("\\p{XDigit}*");
        Matcher m = p.matcher(iv1);
        if (!m.matches()) {
            throw new Exception("string 1 data range:[0-9][a-f][A-F]");
        }
        m = p.matcher(iv2);
        if (!m.matches()) {
            throw new Exception("string 2 data range:[0-9][a-f][A-F]");
        }
        byte[] iv1Bytes = GF.hexToByte(iv1);
        byte[] iv2Bytes = GF.hexToByte(iv2);
        byte[] temp = new byte[iv1Bytes.length];
        for (int i = 0; i < iv1Bytes.length; ++i) {
            temp[i] = (byte)((iv1Bytes[i] ^ iv2Bytes[i]) & 0xFF);
        }
        return temp;
    }

    public static int checkData(String data, int len) {
        int length = data.length();
        if (length != len) {
            return -9006;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.digit(data.charAt(i), 16) >= 0) continue;
            return -9006;
        }
        return 0;
    }

    public static int parseInt(String input) {
        int mod;
        try {
            mod = Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return -1104;
        }
        return mod;
    }

    public static String XOR(int n, String ... strings) {
        int i;
        if (strings[0].length() % 2 != 0) {
            return "-1";
        }
        byte[] b1 = GF.X2CB(strings[0]);
        int length = b1.length;
        byte[][] temp = new byte[n][];
        byte[] rtn = new byte[length];
        for (i = 0; i < length; ++i) {
            rtn[i] = 0;
        }
        for (i = 0; i < n; ++i) {
            temp[i] = GF.X2CB(strings[i]);
            if (temp[i].length == length) continue;
            return "-2";
        }
        for (int j = 0; j < length; ++j) {
            for (int i2 = 0; i2 < n; ++i2) {
                int n2 = j;
                rtn[n2] = (byte)(rtn[n2] ^ temp[i2][j]);
            }
        }
        return GF.C2XS(rtn);
    }

    public static String padString(String str, String patch, int totalLen) {
        StringBuilder temp = new StringBuilder(str);
        int len = temp.length();
        int addLen = totalLen - len;
        for (int i = 0; i < addLen; ++i) {
            temp.insert(0, patch);
        }
        return temp.toString();
    }

    public static String padStringAfter(String str, String patch, int totalLen) {
        StringBuilder temp = new StringBuilder(str);
        int len = temp.length();
        int addLen = totalLen - len;
        for (int i = 0; i < addLen; ++i) {
            temp.append(patch);
        }
        return temp.toString();
    }

    public static String getCanonicalPath(String path) {
        String rtn;
        try {
            File file = new File(path).getCanonicalFile();
            rtn = file.exists() ? file.getCanonicalPath() : new File(".." + File.separator + path).getCanonicalPath();
        }
        catch (IOException e) {
            rtn = null;
        }
        return rtn;
    }

    public static boolean verifyHex(String hex) {
        return !GF.isBlank(hex) && hex.matches("(\\p{XDigit}{2})+");
    }

    public static boolean verifyHex(String hex, int length) {
        return !GF.isBlank(hex) && hex.matches("(\\p{XDigit}{" + length + "})");
    }

    public static boolean verifyNumberAndLength(String hex, int length) {
        return !GF.isBlank(hex) && hex.matches("\\d{" + length + "}");
    }

    public static boolean verifyNumber(String hex, int length) {
        return !GF.isBlank(hex) && hex.matches("\\d{" + length + "}");
    }

    public static boolean verifyNumber(String hex) {
        return !GF.isBlank(hex) && hex.matches("\\d*");
    }

    public static boolean verifyBase64(String encPin) {
        return !GF.isBlank(encPin) && encPin.matches("[\\p{Alnum}+/]+[=]{0,2}");
    }

    public static boolean verifyString(String str, String[] strs) {
        if (strs == null) {
            return false;
        }
        if (str == null) {
            return false;
        }
        for (int i = 0; i < strs.length; ++i) {
            if (!str.equalsIgnoreCase(strs[i])) continue;
            return true;
        }
        return false;
    }
}

