/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.utils;

import java.io.File;

public class Util4file {
    public static boolean checkFileReadAccess(String path) {
        if (!Util4file.isStringNotNullAndNotEmpty(path)) {
            return false;
        }
        if (!Util4file.checkFileExists(path)) {
            return false;
        }
        try {
            File file = new File(path);
            return file.canRead();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkFileWriteAccess(String path) {
        if (!Util4file.isStringNotNullAndNotEmpty(path)) {
            return false;
        }
        if (!Util4file.checkFileExists(path)) {
            return false;
        }
        try {
            File file = new File(path);
            return file.canWrite();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkFileExists(String path) {
        if (!Util4file.isStringNotNullAndNotEmpty(path)) {
            return false;
        }
        File file = new File(path);
        return Util4file.checkFileExists(file);
    }

    public static boolean checkFileExists(File file) {
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public static boolean isStringNotNullAndNotEmpty(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static String getAbsoluteFilePath(String filePath) {
        if (!Util4file.isStringNotNullAndNotEmpty(filePath)) {
            return null;
        }
        File file = new File(filePath);
        return file.getAbsolutePath();
    }
}

