/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    public static String macStr = "";
    public static String ipAddr = "";

    private Util() {
    }

    public static String fieldFormatWithEnCoding(String src, String type, int length, String encoding) throws UnsupportedEncodingException {
        String formatStr = "";
        String tmp = "";
        if (src == null) {
            src = "";
        }
        int srcLen = src.getBytes(encoding).length;
        if ("c".equals(type)) {
            for (int i = 0; i < length - srcLen; ++i) {
                tmp = tmp + " ";
            }
            formatStr = src + tmp;
        } else if ("n".equals(type)) {
            for (int i = 0; i < length - srcLen; ++i) {
                tmp = tmp + "0";
            }
            formatStr = tmp + src;
        } else {
            for (int i = 0; i < length - srcLen; ++i) {
                tmp = tmp + " ";
            }
            formatStr = src + tmp;
        }
        return formatStr;
    }

    public static String filterNewLine(String str) {
        if (str == null) {
            str = "";
        }
        return str.replaceAll("\\r|\\n", " ");
    }

    public static String fieldTrim(String src, String type) throws Exception {
        String formatStr = "";
        if ("c".equals(type)) {
            byte[] buf = src.getBytes(Util.getEncoding());
            int len = buf.length;
            byte[] tmp = buf;
            for (int i = len - 1; i >= 0 && buf[i] == 32; --i) {
                tmp = new byte[i];
                System.arraycopy(buf, 0, tmp, 0, i);
            }
            formatStr = new String(tmp, Util.getEncoding());
        } else if ("n".equals(type)) {
            byte[] buf = src.getBytes(Util.getEncoding());
            int len = buf.length;
            byte[] tmp = buf;
            for (int i = 0; i < len; ++i) {
                if (buf[i] >= 48 && buf[i] <= 57) continue;
                throw new Exception(src + ":\u6570\u5b57\u578b\u5b57\u6bb5\u5fc5\u987b\u5168\u90e8\u4e3a\u6570\u5b57\u7ec4\u6210");
            }
            formatStr = new String(tmp, Util.getEncoding());
        } else {
            return src;
        }
        return formatStr;
    }

    public static String zeroTrim(String src) throws Exception {
        int i;
        String formatStr = "";
        byte[] buf = src.getBytes(Util.getEncoding());
        int len = buf.length;
        byte[] tmp = buf;
        for (i = 0; i < len; ++i) {
            if (buf[i] >= 48 && buf[i] <= 57) continue;
            throw new Exception(src + ":\u6570\u5b57\u578b\u5b57\u6bb5\u5fc5\u987b\u5168\u90e8\u4e3a\u6570\u5b57\u7ec4\u6210");
        }
        for (i = 0; i < len && buf[i] == 48; ++i) {
            tmp = new byte[len - i - 1];
            System.arraycopy(buf, i + 1, tmp, 0, len - i - 1);
        }
        formatStr = new String(tmp, Util.getEncoding());
        return formatStr;
    }

    public static boolean isNum(String src) {
        if (src == null) {
            return false;
        }
        String rex = "[0-9]+";
        return src.matches(rex);
    }

    public static boolean isDate(String src) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        try {
            if (formatter.parse(src) == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isTime(String src) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
        try {
            if (formatter.parse(src) == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isLongTime(String src) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        try {
            if (formatter.parse(src) == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getMapValue(Map<String, String> map, String key) throws Exception {
        if (map == null) {
            return "";
        }
        String value = map.get(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getListCyscly(List<String> list, int i) throws Exception {
        if (list == null) {
            return "";
        }
        if (i >= list.size()) {
            throw new Exception("\u96c6\u5408" + list + " \u5927\u5c0f\u8ddf\u5faa\u73af\u6570" + i + "\u4e0d\u7b26!");
        }
        return list.get(i);
    }

    public static String getEncoding() {
        return "UTF-8";
    }

    public static int countTax(String msgStr, String tax) throws Exception {
        int i = 0;
        try {
            String regexStr = "\\" + tax;
            Pattern p = Pattern.compile(regexStr, 32);
            Matcher m = p.matcher(msgStr);
            while (m.find()) {
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception("\u7edf\u8ba1\u5b57\u7b26\u4e32\u7684" + tax + "\u6570\u76ee\u65f6\u53d1\u751f\u9519\u8bef!");
        }
        return i;
    }

    public static int StringToInt(String src) {
        try {
            if (src == null || "".equals(src)) {
                return 0;
            }
            return Integer.parseInt(src);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int StringToInt(String src, int defalutValue) {
        try {
            if (src == null) {
                return defalutValue;
            }
            return Integer.parseInt(src);
        }
        catch (Exception e) {
            return defalutValue;
        }
    }

    public static boolean PathIsExist(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static String getIp() {
        if (!"".equalsIgnoreCase(ipAddr)) {
            return ipAddr;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
            ipAddr = addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            ipAddr = "0";
        }
        return ipAddr;
    }

    public static List<String> getStrForRegex(String str, String regex) throws Exception {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        ArrayList<String> l = new ArrayList<String>();
        while (m.find()) {
            l.add(m.group());
        }
        return l;
    }

    public static void FileToFile(String srcFile, String dstFile) throws Exception {
        File delFile = new File(srcFile);
        File f2 = new File(dstFile);
        if (!delFile.exists()) {
            return;
        }
        if (!f2.exists()) {
            f2.mkdir();
        }
        if (delFile.isDirectory()) {
            File[] files = delFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                String name = f.getAbsolutePath();
                String fileName = f.getName();
                String dstFileName = dstFile + File.separator + fileName;
                if (f.isDirectory()) {
                    File temp = new File(dstFileName);
                    if (!temp.exists()) {
                        temp.mkdir();
                    }
                    Util.FileToFile(name, dstFileName);
                    continue;
                }
                Util.copyFile(name, dstFileName);
            }
        } else {
            Util.copyFile(srcFile, dstFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String srcFile, String distFile) {
        boolean flag = false;
        File f = null;
        FileInputStream fis = null;
        FileOutputStream fop = null;
        try {
            int i = 0;
            byte[] b = new byte[2048];
            f = new File(srcFile);
            fis = new FileInputStream(f);
            fop = new FileOutputStream(distFile);
            while ((i = fis.read(b)) != -1) {
                fop.write(b, 0, i);
            }
            fop.flush();
            flag = true;
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {
                flag = false;
            }
            try {
                fop.close();
            }
            catch (Exception e) {
                flag = false;
            }
        }
        return flag;
    }

    public static List<String> selectFiles(String fileName, String filter, List<String> fileNameList) {
        File file = new File(fileName);
        File[] subFile = file.listFiles();
        return Util.selectAllFile(subFile, filter, fileNameList);
    }

    private static List<String> selectAllFile(File[] subFile, String filter, List<String> fileNameList) {
        ArrayList<String> fileList = new ArrayList<String>();
        for (int i = 0; i < subFile.length; ++i) {
            if (subFile[i].isFile()) {
                fileList.add(subFile[i].getAbsolutePath());
                fileNameList.add(subFile[i].getName());
                continue;
            }
            File[] grandFile = subFile[i].listFiles();
            Util.selectAllFile(grandFile, filter, fileNameList);
        }
        return fileList;
    }

    public static String getMacAddress() {
        StringBuffer buf = new StringBuffer();
        InetAddress inet = null;
        NetworkInterface net = null;
        byte[] mac = null;
        if (!"".equalsIgnoreCase(macStr)) {
            return macStr;
        }
        try {
            inet = InetAddress.getLocalHost();
            net = NetworkInterface.getByInetAddress(inet);
            mac = net.getHardwareAddress();
        }
        catch (Throwable t) {
            return "00-00-00-00-00-00";
        }
        if (mac != null) {
            for (int i = 0; i < mac.length; ++i) {
                String temp;
                if (i > 0) {
                    buf.append("-");
                }
                if ((temp = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                    temp = 0 + temp;
                }
                buf.append(temp);
            }
            macStr = buf.toString().toUpperCase();
        } else {
            macStr = "00-00-00-00-00-00";
        }
        return macStr;
    }

    public static String utf8ToUnicode(String utf8Str) {
        char[] myBuffer = utf8Str.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < utf8Str.length(); ++i) {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(myBuffer[i]);
            if (ub == Character.UnicodeBlock.BASIC_LATIN) {
                sb.append(myBuffer[i]);
                continue;
            }
            if (ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                int j = myBuffer[i] - 65248;
                sb.append((char)j);
                continue;
            }
            short s = (short)myBuffer[i];
            String hexS = Integer.toHexString(s);
            String unicode = "\\u" + hexS;
            sb.append(unicode.toLowerCase());
        }
        return sb.toString();
    }

    public static String unicodeToGbk(String unicodeStr) {
        int index = 0;
        StringBuffer buffer = new StringBuffer();
        int unicodeLen = unicodeStr.length();
        while (index < unicodeLen) {
            if (index >= unicodeLen - 1 || !"\\u".equals(unicodeStr.substring(index, index + 2))) {
                buffer.append(unicodeStr.charAt(index));
                ++index;
                continue;
            }
            String charStr = "";
            charStr = unicodeStr.substring(index + 2, index + 6);
            char letter = (char)Integer.parseInt(charStr, 16);
            buffer.append(letter);
            index += 6;
        }
        return buffer.toString();
    }

    public static String getDateTime() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sf.format(new Date());
    }

    public static String getDate(Date d) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        return sf.format(d);
    }

    public static String formatTime(long t) {
        Calendar cl = Calendar.getInstance();
        cl.setTimeInMillis(t);
        Date d = cl.getTime();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strD = sf.format(d);
        return strD;
    }

    public static byte[] Xor(byte[] data1, byte[] data2) {
        if (data1 == null || data2 == null || data1.length != data2.length) {
            return null;
        }
        byte[] temp = new byte[data1.length];
        for (int i = 0; i < data1.length; ++i) {
            temp[i] = (byte)((data1[i] ^ data2[i]) & 0xFF);
        }
        return temp;
    }
}

