/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.utils;

import java.security.Provider;
import java.security.Security;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RuntimeEnvironment {
    private static final String BC_PROVIDER_CLASS_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static AtomicBoolean BOUNCY_CASTLE_AVAILABLE = new AtomicBoolean(false);

    private RuntimeEnvironment() {
    }

    public static void enableBouncyCastleIfPossible() {
        if (BOUNCY_CASTLE_AVAILABLE.get()) {
            return;
        }
        try {
            Provider[] providers;
            Class<?> clazz = Class.forName(BC_PROVIDER_CLASS_NAME);
            for (Provider provider : providers = Security.getProviders()) {
                if (!clazz.isInstance(provider)) continue;
                BOUNCY_CASTLE_AVAILABLE.set(true);
                return;
            }
            Security.addProvider((Provider)clazz.newInstance());
            BOUNCY_CASTLE_AVAILABLE.set(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        RuntimeEnvironment.enableBouncyCastleIfPossible();
    }
}

