/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.utils;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMNamedCurves;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ECParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECCurve;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.util.encoders.Hex;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcSymmetricKeyParameter;
import com.icbc.hsm.software.parms.icbc.TempKeyBuilder;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class Helper {
    private Helper() {
    }

    public static AsymmetricKeyParameter toAsymmetricKey(byte[] data, String type) throws Exception {
        if ("SM2private".equalsIgnoreCase(type)) {
            X9ECParameters x9 = GMNamedCurves.getByName("sm2p256v1");
            ECCurve ecv = x9.getCurve();
            ECPoint ept = x9.getG();
            ECDomainParameters domainParams = new ECDomainParameters(ecv, ept, ecv.getOrder());
            BigInteger D = new BigInteger(1, data);
            ECPrivateKeyParameters epp = new ECPrivateKeyParameters(D, domainParams);
            return epp;
        }
        if ("SM2public".equalsIgnoreCase(type)) {
            X9ECParameters x9 = GMNamedCurves.getByName("sm2p256v1");
            ECCurve ecv = x9.getCurve();
            ECPoint ept = x9.getG();
            ECDomainParameters domainParams = new ECDomainParameters(ecv, ept, ecv.getOrder());
            String XY = Hex.toHexString(data);
            if (!XY.startsWith("04")) {
                throw new Exception("key data error!");
            }
            String X = XY.substring(2, 66);
            String Y = XY.substring(66);
            ECPoint Q = ecv.createPoint(new BigInteger(X, 16), new BigInteger(Y, 16));
            ECPublicKeyParameters ep = new ECPublicKeyParameters(Q, domainParams);
            return ep;
        }
        if ("RSAprivate".equalsIgnoreCase(type)) {
            RSAPrivateKey prv = RSAPrivateKey.getInstance(data);
            RSAPrivateCrtKeyParameters rsaPrv = new RSAPrivateCrtKeyParameters(prv.getModulus(), prv.getPublicExponent(), prv.getPrivateExponent(), prv.getPrime1(), prv.getPrime2(), prv.getExponent1(), prv.getExponent2(), prv.getCoefficient());
            return rsaPrv;
        }
        if ("RSApublic".equalsIgnoreCase(type)) {
            RSAPublicKey pub = RSAPublicKey.getInstance(data);
            RSAKeyParameters rsaPub = new RSAKeyParameters(false, pub.getModulus(), pub.getPublicExponent());
            return rsaPub;
        }
        throw new Exception("key type not support! " + type);
    }

    public static CipherParameters toBCkey(CipherParameters key) throws Exception {
        CipherParameters hsmParms = key;
        if (key instanceof ClearKeyParameter) {
            hsmParms = ((ClearKeyParameter)key).getBCkey();
        }
        if (IcbcEnvironment.isICBCEnvironment()) {
            if (key instanceof IcbcSymmetricKeyParameter) {
                hsmParms = ((IcbcSymmetricKeyParameter)key).getBCkey();
            }
            if (key instanceof IcbcAsymmetricKeyParameter) {
                hsmParms = ((IcbcAsymmetricKeyParameter)key).getBCkey();
            }
        }
        return hsmParms;
    }

    public static CipherParameters toClearRsaKey(byte[] data) {
        ASN1Object tempKey;
        KeyFactory kf2;
        ClearKeyParameter rsaKey = null;
        try {
            kf2 = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec pkcs8 = new PKCS8EncodedKeySpec(data);
            java.security.interfaces.RSAPrivateKey prk = (java.security.interfaces.RSAPrivateKey)kf2.generatePrivate(pkcs8);
            if (prk instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey key = (RSAPrivateCrtKey)prk;
                RSAPrivateKey tempKey2 = new RSAPrivateKey(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrimeP(), key.getPrimeQ(), key.getPrimeExponentP(), key.getPrimeExponentQ(), key.getCrtCoefficient());
                rsaKey = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"RSA", (boolean)true, (byte[])tempKey2.getEncoded()) : ClearKeyParameter.getInstance("RSA", true, tempKey2.getEncoded());
            } else if (prk instanceof java.security.interfaces.RSAPrivateKey) {
                tempKey = new RSAPrivateKey(prk.getModulus(), new BigInteger("0"), prk.getPrivateExponent(), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"));
                rsaKey = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"RSA", (boolean)true, (byte[])tempKey.getEncoded()) : ClearKeyParameter.getInstance("RSA", true, tempKey.getEncoded());
            }
        }
        catch (Exception kf2) {
            // empty catch block
        }
        if (rsaKey == null) {
            try {
                kf2 = KeyFactory.getInstance("RSA");
                X509EncodedKeySpec x509 = new X509EncodedKeySpec(data);
                java.security.interfaces.RSAPublicKey key = (java.security.interfaces.RSAPublicKey)kf2.generatePublic(x509);
                tempKey = new RSAPublicKey(key.getModulus(), key.getPublicExponent());
                rsaKey = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"RSA", (boolean)false, (byte[])tempKey.getEncoded()) : ClearKeyParameter.getInstance("RSA", false, tempKey.getEncoded());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rsaKey;
    }

    public static byte[] toPKCS1(byte[] data) {
        ASN1Object tempKey;
        KeyFactory kf2;
        byte[] pkcs1Key = null;
        try {
            kf2 = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec pkcs8 = new PKCS8EncodedKeySpec(data);
            java.security.interfaces.RSAPrivateKey prk = (java.security.interfaces.RSAPrivateKey)kf2.generatePrivate(pkcs8);
            if (prk instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey key = (RSAPrivateCrtKey)prk;
                RSAPrivateKey tempKey2 = new RSAPrivateKey(key.getModulus(), key.getPublicExponent(), key.getPrivateExponent(), key.getPrimeP(), key.getPrimeQ(), key.getPrimeExponentP(), key.getPrimeExponentQ(), key.getCrtCoefficient());
                pkcs1Key = tempKey2.getEncoded();
            } else if (prk instanceof java.security.interfaces.RSAPrivateKey) {
                tempKey = new RSAPrivateKey(prk.getModulus(), new BigInteger("0"), prk.getPrivateExponent(), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"));
                pkcs1Key = tempKey.getEncoded();
            }
        }
        catch (Exception kf2) {
            // empty catch block
        }
        if (pkcs1Key == null) {
            try {
                kf2 = KeyFactory.getInstance("RSA");
                X509EncodedKeySpec x509 = new X509EncodedKeySpec(data);
                java.security.interfaces.RSAPublicKey key = (java.security.interfaces.RSAPublicKey)kf2.generatePublic(x509);
                tempKey = new RSAPublicKey(key.getModulus(), key.getPublicExponent());
                pkcs1Key = tempKey.getEncoded();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pkcs1Key;
    }
}

