/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.parms;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.MessageDigest;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.utils.CallerCheck;
import com.icbc.hsm.software.utils.Helper;
import com.icbc.hsm.utils.encoders.Hex;
import java.security.SecureRandom;
import java.util.Arrays;

public class ClearKeyParameter
implements HsmKeyParameter {
    private transient String algorithmType;
    private transient Long keyLengthInBit;
    private transient boolean isPrivate;
    private transient byte[] key;
    private transient byte[] password;
    private transient byte[] salt = null;
    private byte[] id;

    @Override
    public String getAlgorithm() {
        return this.algorithmType;
    }

    public int getKeySize() {
        return this.keyLengthInBit.intValue();
    }

    public CipherParameters getBCkey() throws Exception {
        byte[] password = this.getPassword(this.password, this.key.length * 8);
        byte[] key = this.key;
        byte[] data = null;
        data = ("SM2".equalsIgnoreCase(this.algorithmType) || "RSA".equalsIgnoreCase(this.algorithmType)) && !this.isPrivate ? Arrays.copyOfRange(key, 0, key.length) : this.unwapKey(key, password);
        CipherParameters parameter = null;
        parameter = "SM2".equalsIgnoreCase(this.algorithmType) || "RSA".equalsIgnoreCase(this.algorithmType) ? Helper.toAsymmetricKey(data, this.getKeyType()) : new KeyParameter(data);
        return parameter;
    }

    public static ClearKeyParameter getInstance(String algorithm, byte[] key) throws Exception {
        ClearKeyParameter newkey = ClearKeyParameter.getInstance(algorithm, false, key);
        return newkey;
    }

    public static ClearKeyParameter getInstance(String algorithm, boolean isPrivate, byte[] key) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment() && !CallerCheck.check(ClearKeyParameter.class.getName())) {
            throw new Exception("clear key function not permit");
        }
        ClearKeyParameter newkey = new ClearKeyParameter(algorithm, isPrivate, key);
        return newkey;
    }

    protected ClearKeyParameter() {
    }

    protected ClearKeyParameter(String algorithm, byte[] key) {
        this(algorithm, false, key);
    }

    protected ClearKeyParameter(String algorithm, boolean isPrivate, byte[] key) {
        this.algorithmType = algorithm;
        this.keyLengthInBit = key.length * 8;
        this.isPrivate = isPrivate;
        try {
            this.password = MessageDigest.digest("SM3", key);
        }
        catch (Exception e) {
            this.password = new byte[0];
        }
        if (("SM2".equalsIgnoreCase(algorithm) || "RSA".equalsIgnoreCase(algorithm)) && !isPrivate) {
            this.key = Arrays.copyOf(key, key.length);
        } else {
            byte[] password = this.getPassword(this.password, key.length * 8);
            this.key = this.wapKey(key, password);
        }
    }

    public void setId(byte[] id) {
        if (id == null) {
            this.id = null;
            return;
        }
        this.id = Arrays.copyOf(id, id.length);
    }

    public byte[] getId() {
        if (this.id == null) {
            return null;
        }
        return Arrays.copyOf(this.id, this.id.length);
    }

    public String toString() {
        return null;
    }

    public String getPublicKey() {
        if (!this.isPrivate) {
            return Hex.toHexString(this.key);
        }
        return null;
    }

    private byte[] getPassword(byte[] pass, int size) {
        if (this.salt == null) {
            SecureRandom random = new SecureRandom();
            this.salt = new byte[32];
            random.nextBytes(this.salt);
        }
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator(new SM3Digest());
        generator.init(pass, this.salt, 16);
        KeyParameter parm = (KeyParameter)generator.generateDerivedParameters(size);
        return parm.getKey();
    }

    private byte[] wapKey(byte[] key, byte[] wappingKey) {
        byte[] rt = new byte[key.length];
        for (int i = 0; i < rt.length; ++i) {
            rt[i] = (byte)((key[i] ^ wappingKey[i]) & 0xFF);
        }
        return rt;
    }

    private byte[] unwapKey(byte[] wappedKey, byte[] wappingKey) {
        byte[] rt = new byte[this.key.length];
        for (int i = 0; i < rt.length; ++i) {
            rt[i] = (byte)((this.key[i] ^ wappingKey[i]) & 0xFF);
        }
        return rt;
    }

    public String getKeyType() {
        if ("SM2".equalsIgnoreCase(this.algorithmType)) {
            if (this.isPrivate) {
                return "SM2private";
            }
            return "SM2public";
        }
        if ("RSA".equalsIgnoreCase(this.algorithmType)) {
            if (this.isPrivate) {
                return "RSAprivate";
            }
            return "RSApublic";
        }
        return null;
    }
}

