/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.journal;

import java.lang.reflect.Method;

public class LogProxy {
    private static final String className = LogProxy.class.getName();
    private static Object logObject = null;
    private static boolean slf4jLoggerFlag = false;
    private static boolean log4jLoggerFlag = false;

    public static synchronized void setLogObject(Object o) {
        logObject = o;
        if (o.getClass().getName().equalsIgnoreCase("org.apache.log4j.Logger")) {
            log4jLoggerFlag = true;
            slf4jLoggerFlag = false;
        }
        if (o.getClass().getName().startsWith("org.apache.logging.slf4j")) {
            log4jLoggerFlag = false;
            slf4jLoggerFlag = true;
        }
    }

    public static String getOccurPosition(StackTraceElement[] se) {
        String position = null;
        for (int i = 0; i < se.length; ++i) {
            if (!className.equalsIgnoreCase(se[i].getClassName())) continue;
            int j = i + 1;
            position = "at " + se[j].getClassName() + " " + se[j].getMethodName() + "() line no. " + se[j].getLineNumber();
            break;
        }
        return position;
    }

    public static void debug(String message) {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        String position = LogProxy.getOccurPosition(se);
        String newMessage = position + ": " + message;
        LogProxy.writeLog("debug", newMessage, null);
    }

    public static void debug(String message, Throwable e) {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        String position = LogProxy.getOccurPosition(se);
        String newMessage = position + ": " + message;
        LogProxy.writeLog("debug", newMessage, e);
    }

    public static void warn(String message) {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        String position = LogProxy.getOccurPosition(se);
        String newMessage = position + ": " + message;
        LogProxy.writeLog("warn", newMessage, null);
    }

    public static void warn(String message, Throwable e) {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        String position = LogProxy.getOccurPosition(se);
        String newMessage = position + ": " + message;
        LogProxy.writeLog("warn", newMessage, e);
    }

    public static void info(String message) {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        String position = LogProxy.getOccurPosition(se);
        String newMessage = position + ": " + message;
        LogProxy.writeLog("info", newMessage, null);
    }

    public static void info(String message, Throwable e) {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        String position = LogProxy.getOccurPosition(se);
        String newMessage = position + ": " + message;
        LogProxy.writeLog("info", newMessage, e);
    }

    public static void error(String message) {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        String position = LogProxy.getOccurPosition(se);
        String newMessage = position + ": " + message;
        LogProxy.writeLog("error", newMessage, null);
    }

    public static void error(String message, Throwable e) {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        String position = LogProxy.getOccurPosition(se);
        String newMessage = position + ": " + message;
        LogProxy.writeLog("error", newMessage, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLog(String type, String message, Throwable e) {
        if (logObject == null) {
            String string = className;
            synchronized (string) {
                if (logObject == null) {
                    Class<?> t1 = null;
                    Class<?> t2 = null;
                    Class<?> t3 = null;
                    try {
                        t1 = Class.forName("org.slf4j.Logger");
                        t2 = Class.forName("org.slf4j.LoggerFactory");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (t1 != null && t2 != null) {
                        try {
                            Method m = t2.getMethod("getLogger", String.class);
                            logObject = m.invoke(null, className);
                            slf4jLoggerFlag = true;
                        }
                        catch (Exception m) {}
                    } else {
                        try {
                            t3 = Class.forName("org.apache.log4j.Logger");
                            if (t3 != null) {
                                Method m = t3.getMethod("getLogger", String.class);
                                logObject = m.invoke(null, className);
                                log4jLoggerFlag = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (!("debug".equalsIgnoreCase(type) || "warn".equalsIgnoreCase(type) || "info".equalsIgnoreCase(type) || "error".equalsIgnoreCase(type))) {
            return;
        }
        try {
            Method m;
            if (e == null) {
                if (slf4jLoggerFlag) {
                    m = logObject.getClass().getMethod(type, String.class);
                    m.invoke(logObject, message);
                }
                if (log4jLoggerFlag) {
                    m = logObject.getClass().getMethod(type, Object.class);
                    m.invoke(logObject, message);
                }
            } else {
                if (slf4jLoggerFlag) {
                    m = logObject.getClass().getMethod(type, String.class, Throwable.class);
                    m.invoke(logObject, message, e);
                }
                if (log4jLoggerFlag) {
                    m = logObject.getClass().getMethod(type, Object.class, Throwable.class);
                    m.invoke(logObject, message, e);
                }
            }
        }
        catch (Exception ex) {
            return;
        }
    }
}

