/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.external;

import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.icbc.hsm.software.apiLib.Cipher;
import com.icbc.hsm.software.basic.AsymmetricCipher;
import com.icbc.hsm.software.basic.Generator;
import com.icbc.hsm.software.basic.PBEkeyGenerate;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.utils.encoders.Hex;
import java.security.SecureRandom;
import java.util.HashMap;

public class ClearKeyFunction {
    private String algorithmType;

    private ClearKeyFunction(String algorithmType) {
        this.algorithmType = algorithmType;
    }

    public static ClearKeyFunction getInstance(String algorithmType) {
        ClearKeyFunction C = new ClearKeyFunction(algorithmType);
        return C;
    }

    public static ClearKeyParameter loadClear(String data, String type) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        ClearKeyParameter key = null;
        if ("DES".equalsIgnoreCase(type) || "DESede".equalsIgnoreCase(type) || "AES".equalsIgnoreCase(type) || "SM4".equalsIgnoreCase(type)) {
            key = ClearKeyParameter.getInstance(type, false, Hex.decode(data));
        } else if ("SM2private".equalsIgnoreCase(type)) {
            key = ClearKeyParameter.getInstance("SM2", true, Hex.decode(data));
        } else if ("RSAprivate".equalsIgnoreCase(type)) {
            key = ClearKeyParameter.getInstance("RSA", true, Hex.decode(data));
        } else if ("SM2public".equalsIgnoreCase(type)) {
            key = ClearKeyParameter.getInstance("SM2", false, Hex.decode(data));
        } else if ("RSApublic".equalsIgnoreCase(type)) {
            key = ClearKeyParameter.getInstance("RSA", false, Hex.decode(data));
        }
        return key;
    }

    public static HashMap<String, String> generateSM2KeyPair() throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        HashMap<String, String> key = new HashMap<String, String>();
        AsymmetricCipherKeyPair keyPair = Generator.generateSM2KeyPair();
        ECPrivateKeyParameters ecPrv = (ECPrivateKeyParameters)keyPair.getPrivate();
        String dHex = String.format("%1$064x", ecPrv.getD());
        ECPublicKeyParameters ecPub = (ECPublicKeyParameters)keyPair.getPublic();
        String xy = "04" + String.format("%1$064x", ecPub.getQ().getAffineXCoord().toBigInteger()) + String.format("%1$064x", ecPub.getQ().getAffineYCoord().toBigInteger());
        key.put("privateKey", dHex);
        key.put("publicKey", xy);
        return key;
    }

    public static String getSM2PublicKey(ClearKeyParameter key) {
        String publicKey = null;
        if ("SM2private".equalsIgnoreCase(key.getKeyType())) {
            CipherParameters cp = null;
            try {
                cp = key.getBCkey();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cp instanceof ECPrivateKeyParameters) {
                ECPrivateKeyParameters p = (ECPrivateKeyParameters)cp;
                ECPoint pt = new FixedPointCombMultiplier().multiply(p.getParameters().getG(), p.getD()).normalize();
                publicKey = "04" + String.format("%1$064x", pt.getAffineXCoord().toBigInteger()) + String.format("%1$064x", pt.getAffineYCoord().toBigInteger());
            }
        } else if ("SM2public".equalsIgnoreCase(key.getKeyType())) {
            publicKey = "04" + key.getPublicKey().toUpperCase();
        }
        return publicKey;
    }

    public KeyHolder generateKey(ClearKeyParameter key, int size) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        byte[] random = this.generateRandom(size);
        byte[] encryptedKey = null;
        ClearKeyParameter parm = null;
        if ("RSA".equalsIgnoreCase(key.getAlgorithm())) {
            if ("SM4".equalsIgnoreCase(this.algorithmType)) {
                throw new Exception("generating SymmetricKey type error! allow type: DES/DESede/AES");
            }
            encryptedKey = AsymmetricCipher.encipher("PKCS1PADDING", true, key, random);
            parm = ClearKeyFunction.loadClear(Hex.toHexString(random), this.algorithmType);
        }
        if ("SM2".equalsIgnoreCase(key.getAlgorithm())) {
            if (!"SM4".equalsIgnoreCase(this.algorithmType)) {
                throw new Exception("generating SymmetricKey type error! allow type: SM4");
            }
            encryptedKey = AsymmetricCipher.encipher("SM2", true, key, random);
            parm = ClearKeyFunction.loadClear(Hex.toHexString(random), this.algorithmType);
        }
        KeyHolder h = new KeyHolder(parm, Hex.toHexString(encryptedKey).toUpperCase());
        return h;
    }

    public ClearKeyParameter importKey(ClearKeyParameter key, String encryptedKey) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment()) {
            throw new Exception("ClearKeyFunction not permit");
        }
        byte[] data = Hex.decode(encryptedKey);
        byte[] clear = null;
        if ("RSA".equalsIgnoreCase(key.getAlgorithm())) {
            if ("SM4".equalsIgnoreCase(this.algorithmType)) {
                throw new Exception("generating SymmetricKey type error! allow type: DES/DESede/AES");
            }
            clear = AsymmetricCipher.encipher("PKCS1PADDING", false, key, data);
        }
        if ("SM2".equalsIgnoreCase(key.getAlgorithm())) {
            if (!"SM4".equalsIgnoreCase(this.algorithmType)) {
                throw new Exception("generating SymmetricKey type error! allow type: SM4");
            }
            clear = AsymmetricCipher.encipher("SM2", false, key, data);
        }
        ClearKeyParameter clearKey = null;
        clearKey = ClearKeyFunction.loadClear(Hex.toHexString(clear), this.algorithmType);
        return clearKey;
    }

    private byte[] generateRandom(int size) throws Exception {
        SecureRandom random = new SecureRandom();
        byte[] pwd = new byte[20];
        random.nextBytes(pwd);
        byte[] salt = new byte[32];
        random.nextBytes(salt);
        byte[] randomKey = PBEkeyGenerate.generatePBEKey("PBKDF2", "SM3", null, size, pwd, salt, 16);
        return randomKey;
    }

    public static String getCheckValue(ClearKeyParameter key) {
        String checkValue = null;
        byte[] data = null;
        Cipher c = Cipher.getInstance(key.getAlgorithm(), "ECB", "NOPADDING");
        if ("DES".equalsIgnoreCase(key.getAlgorithm())) {
            data = new byte[8];
        }
        if ("DESede".equalsIgnoreCase(key.getAlgorithm())) {
            data = new byte[8];
        }
        if ("AES".equalsIgnoreCase(key.getAlgorithm())) {
            data = new byte[16];
        }
        if ("SM4".equalsIgnoreCase(key.getAlgorithm())) {
            data = new byte[16];
        }
        try {
            byte[] kcv = c.encipher(key, data);
            checkValue = Hex.toHexString(kcv);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return checkValue;
    }

    public static KeyHolder restoreKeyHolder(String data) {
        ClearKeyFunction cf;
        if (data == null || data.length() == 0) {
            return null;
        }
        String[] records = data.split(";");
        if (records.length != 3) {
            return null;
        }
        ClearKeyParameter parm = null;
        try {
            parm = ClearKeyFunction.loadClear(records[1], records[0]);
        }
        catch (Exception e) {
            return null;
        }
        ClearKeyFunction clearKeyFunction2 = cf = ClearKeyFunction.getInstance(records[0]);
        clearKeyFunction2.getClass();
        KeyHolder h = clearKeyFunction2.new KeyHolder(parm, records[2]);
        return h;
    }

    public class KeyHolder {
        private ClearKeyParameter internalKey = null;
        private String ExportedKey = null;

        KeyHolder(ClearKeyParameter key1, String key2) {
            this.internalKey = key1;
            this.ExportedKey = key2;
        }

        public ClearKeyParameter getHsmKeyParameter() {
            return this.internalKey;
        }

        public String getWappedExportedKey() {
            return this.ExportedKey;
        }

        public String backupKeyHolder() {
            String type = this.internalKey.getAlgorithm();
            byte[] clearKey = null;
            try {
                clearKey = ((KeyParameter)this.internalKey.getBCkey()).getKey();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clearKey == null || clearKey.length == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder(1024);
            sb.append(type).append(";").append(Hex.toHexString(clearKey)).append(";").append(this.ExportedKey);
            return sb.toString();
        }
    }
}

