/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.cert;

import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcDigestProvider;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IcbcExtendDigestProvider
implements BcDigestProvider {
    private static final Map extendlookup = IcbcExtendDigestProvider.createTable();
    private static BcDigestProvider bcDefaultDigestProvider = BcDefaultDigestProvider.INSTANCE;
    public static final BcDigestProvider INSTANCE = new IcbcExtendDigestProvider();

    private static Map createTable() {
        HashMap<ASN1ObjectIdentifier, 1> table = new HashMap<ASN1ObjectIdentifier, 1>();
        table.put(GMObjectIdentifiers.sm3, new BcDigestProvider(){

            @Override
            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SM3Digest();
            }
        });
        return Collections.unmodifiableMap(table);
    }

    IcbcExtendDigestProvider() {
    }

    @Override
    public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
        BcDigestProvider extProv = (BcDigestProvider)extendlookup.get(digestAlgorithmIdentifier.getAlgorithm());
        if (extProv == null) {
            bcDefaultDigestProvider.get(digestAlgorithmIdentifier);
        }
        if (extProv == null) {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return extProv.get(digestAlgorithmIdentifier);
    }
}

