/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.cert;

import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.bc.BcX509v3CertificateBuilder;
import com.icbc.bcpkix.org.bouncycastle.openssl.PEMParser;
import com.icbc.bcpkix.org.bouncycastle.operator.ContentSigner;
import com.icbc.bcpkix.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.icbc.bcpkix.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcContentSignerBuilder;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.icbc.bcpkix.org.bouncycastle.pkcs.bc.BcPKCS10CertificationRequestBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMNamedCurves;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.icbc.bcprov.org.bouncycastle.asn1.x500.X500Name;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ECParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECCurve;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.util.encoders.Hex;
import com.icbc.bcprov.org.bouncycastle.util.io.pem.PemObject;
import com.icbc.bcprov.org.bouncycastle.util.io.pem.PemWriter;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.cert.IcbcContentSignerBuilder;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.software.parms.icbc.TempKeyBuilder;
import com.icbc.hsm.utils.encoders.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.util.Date;

public class IcbcCertificateHelper {
    public static String generateCertificate(X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, IcbcAsymmetricKeyParameter subjectPublicKey, IcbcAsymmetricKeyParameter issuerPrivateKey, String digestAlgoName) throws Exception {
        AlgorithmIdentifier digAlgId;
        AlgorithmIdentifier signAlgId;
        AsymmetricKeyParameter pubKey = null;
        AsymmetricKeyParameter prvKey = null;
        pubKey = (AsymmetricKeyParameter)subjectPublicKey.getBCkey();
        prvKey = (AsymmetricKeyParameter)issuerPrivateKey.getBCkey();
        String signatureAlgoName = issuerPrivateKey.getKeyType();
        BcContentSignerBuilder sb = null;
        if (signatureAlgoName == null) {
            throw new Exception("signatureAlgorithm Name not found in sign private key");
        }
        if (signatureAlgoName.indexOf("RSA") >= 0) {
            signAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(digestAlgoName + "WITHRSA");
            digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(digestAlgoName);
            sb = new BcRSAContentSignerBuilder(signAlgId, digAlgId);
        } else if (signatureAlgoName.indexOf("SM2") >= 0) {
            signAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SM3WITHSM2");
            digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(digestAlgoName);
            sb = new IcbcContentSignerBuilder(signAlgId, digAlgId);
        }
        ContentSigner signer = sb.build(prvKey);
        BcX509v3CertificateBuilder cb = new BcX509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, pubKey);
        X509CertificateHolder certHolder = cb.build(signer);
        String certB64 = null;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PemWriter pWrt = new PemWriter(new OutputStreamWriter(bOut));
        try {
            pWrt.writeObject(new PemObject("CERTIFICATE", certHolder.getEncoded()));
            pWrt.close();
        }
        catch (Exception e) {
            throw new CertificateEncodingException("can't encode certificate to PEM");
        }
        certB64 = bOut.toString();
        return certB64;
    }

    public static String generatePKCS10CertificationRequest(X500Name subject, IcbcAsymmetricKeyParameter subjectPublicKey, IcbcAsymmetricKeyParameter subjectPrivateKey, String digestAlgoName) throws Exception {
        AlgorithmIdentifier digAlgId;
        AlgorithmIdentifier signAlgId;
        AsymmetricKeyParameter pubKey = null;
        AsymmetricKeyParameter prvKey = null;
        pubKey = (AsymmetricKeyParameter)subjectPublicKey.getBCkey();
        prvKey = (AsymmetricKeyParameter)subjectPrivateKey.getBCkey();
        BcPKCS10CertificationRequestBuilder br = new BcPKCS10CertificationRequestBuilder(subject, pubKey);
        String signatureAlgoName = subjectPrivateKey.getKeyType();
        BcContentSignerBuilder sb = null;
        if (signatureAlgoName == null) {
            throw new Exception("signatureAlgorithm Name not found in sign private key");
        }
        if (signatureAlgoName.indexOf("RSA") >= 0) {
            signAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(digestAlgoName + "WITHRSA");
            digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(digestAlgoName);
            sb = new BcRSAContentSignerBuilder(signAlgId, digAlgId);
        } else if (signatureAlgoName.indexOf("SM2") >= 0) {
            signAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SM3WITHSM2");
            digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(digestAlgoName);
            sb = new IcbcContentSignerBuilder(signAlgId, digAlgId);
        }
        ContentSigner signer = sb.build(prvKey);
        PKCS10CertificationRequest p10 = br.build(signer);
        String p10String = Base64.toBase64String(p10.getEncoded());
        return p10String;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HsmKeyParameter getPubicKeyFromCert(byte[] x509cert) throws Exception {
        ClearKeyParameter key = null;
        X509CertificateHolder x509Holder = null;
        BufferedReader keyParser = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(x509cert);
            keyParser = new PEMParser(new InputStreamReader(bis));
            Object keyObj = ((PEMParser)keyParser).readObject();
            if (keyObj instanceof X509CertificateHolder) {
                x509Holder = (X509CertificateHolder)keyObj;
            }
        }
        catch (Exception bis) {
        }
        finally {
            keyParser.close();
        }
        if (x509Holder == null) {
            String temp = new String(x509cert);
            if (temp.matches("[\\p{Alnum}\\p{Space}\\+\\/\\=]+")) {
                x509cert = Base64.decode(temp);
            }
            x509Holder = new X509CertificateHolder(x509cert);
        }
        SubjectPublicKeyInfo publicKeyInfo = x509Holder.getSubjectPublicKeyInfo();
        ASN1Primitive publicKeyAsn1 = publicKeyInfo.parsePublicKey();
        publicKeyInfo.getAlgorithm();
        RSAPublicKey asn1PublicKey = RSAPublicKey.getInstance(publicKeyAsn1);
        byte[] keyByte = asn1PublicKey.getEncoded();
        key = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"RSA", (byte[])keyByte) : ClearKeyParameter.getInstance("RSA", keyByte);
        return key;
    }

    public static AsymmetricKeyParameter toAsymmetricKey(byte[] data, String type) throws Exception {
        if ("SM2private".equalsIgnoreCase(type)) {
            X9ECParameters x9 = GMNamedCurves.getByName("sm2p256v1");
            ECCurve ecv = x9.getCurve();
            ECPoint ept = x9.getG();
            ECDomainParameters domainParams = new ECDomainParameters(ecv, ept, ecv.getOrder());
            BigInteger D = new BigInteger(1, data);
            ECPrivateKeyParameters epp = new ECPrivateKeyParameters(D, domainParams);
            return epp;
        }
        if ("SM2public".equalsIgnoreCase(type)) {
            X9ECParameters x9 = GMNamedCurves.getByName("sm2p256v1");
            ECCurve ecv = x9.getCurve();
            ECPoint ept = x9.getG();
            ECDomainParameters domainParams = new ECDomainParameters(ecv, ept, ecv.getOrder());
            String XY = Hex.toHexString(data);
            if (!XY.startsWith("04")) {
                throw new Exception("key data error!");
            }
            String X = XY.substring(2, 64);
            String Y = XY.substring(66);
            ECPoint Q = ecv.createPoint(new BigInteger(X, 16), new BigInteger(Y, 16));
            ECPublicKeyParameters ep = new ECPublicKeyParameters(Q, domainParams);
            return ep;
        }
        if ("RSAprivate".equalsIgnoreCase(type)) {
            RSAPrivateKey prv = RSAPrivateKey.getInstance(data);
            RSAPrivateCrtKeyParameters rsaPrv = new RSAPrivateCrtKeyParameters(prv.getModulus(), prv.getPublicExponent(), prv.getPrivateExponent(), prv.getPrime1(), prv.getPrime2(), prv.getExponent1(), prv.getExponent2(), prv.getCoefficient());
            return rsaPrv;
        }
        if ("RSApublic".equalsIgnoreCase(type)) {
            RSAPublicKey pub = RSAPublicKey.getInstance(data);
            RSAKeyParameters rsaPub = new RSAKeyParameters(false, pub.getModulus(), pub.getPublicExponent());
            return rsaPub;
        }
        throw new Exception("key type not support! " + type);
    }
}

