/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic.extend;

import com.icbc.bcprov.org.bouncycastle.crypto.engines.AESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.GCMBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AEADParameters;

public class AesGcmCipherOfICBC {
    private GCMBlockCipher cipher = null;
    private AEADParameters parameters = null;

    public static AesGcmCipherOfICBC getInstance() {
        return new AesGcmCipherOfICBC();
    }

    public void init(boolean forEncryption, AEADParameters parameters) {
        this.init(null, forEncryption, parameters);
    }

    private void init(GCMMultiplier m, boolean forEncryption, AEADParameters parameters) {
        this.parameters = parameters;
        this.cipher = new GCMBlockCipher(new AESEngine(), m);
        this.cipher.init(forEncryption, parameters);
    }

    public byte[] docipher(byte[] text) throws Exception {
        if (this.cipher == null) {
            throw new Exception("cipher instance not initialized!");
        }
        byte[] enc = new byte[this.cipher.getOutputSize(text.length)];
        int len = this.cipher.processBytes(text, 0, text.length, enc, 0);
        int macLen = this.cipher.doFinal(enc, len);
        len += macLen;
        return enc;
    }

    public byte[] getMac() {
        return this.cipher.getMac();
    }

    public void reset() {
        this.cipher.reset();
        this.parameters = null;
    }
}

