/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.BlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.BufferedBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.DataLengthException;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.AESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.DESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.DESedeEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.SM4Engine;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.CBCBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.CFBBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.OFBBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.PKCS7Padding;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.X923Padding;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithIV;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.utils.Helper;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class SymmetricCipher {
    private SymmetricCipher() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] blockCipher(String algorithm, String mode, String padding, boolean encrypt, CipherParameters parms, byte[] initVector, byte[] input) throws Exception {
        CipherParameters hsmParms = Helper.toBCkey(parms);
        BlockCipher b = null;
        if ("AES".equalsIgnoreCase(algorithm)) {
            b = new AESEngine();
        } else if ("DES".equalsIgnoreCase(algorithm)) {
            b = new DESEngine();
        } else if ("DESede".equalsIgnoreCase(algorithm)) {
            b = new DESedeEngine();
        } else {
            if (!"SM4".equalsIgnoreCase(algorithm)) throw new ParmErrorException("Cipher Algorithm Name error:" + algorithm);
            b = new SM4Engine();
        }
        int estimateIVSize = b.getBlockSize();
        CipherParameters cparms = hsmParms;
        if ("CBC".equalsIgnoreCase(mode)) {
            b = new CBCBlockCipher(b);
            if (initVector == null) {
                byte[] tmpIV = new byte[estimateIVSize];
                cparms = new ParametersWithIV(hsmParms, tmpIV);
            } else {
                if (initVector.length != estimateIVSize) throw new ParmErrorException("initialisation vector must be the same length as cipher block size");
                cparms = new ParametersWithIV(hsmParms, initVector);
            }
        } else if (!"ECB".equalsIgnoreCase(mode)) {
            if ("CFB".equalsIgnoreCase(mode)) {
                b = new CFBBlockCipher(b, 8);
                if (initVector != null && initVector.length == estimateIVSize) {
                    cparms = new ParametersWithIV(hsmParms, initVector);
                }
            } else {
                if (!"OFB".equalsIgnoreCase(mode)) throw new ParmErrorException("Cipher Algorithm Mode error:" + mode);
                b = new OFBBlockCipher(b, 8);
                if (initVector != null && initVector.length == estimateIVSize) {
                    cparms = new ParametersWithIV(hsmParms, initVector);
                }
            }
        }
        BufferedBlockCipher cipher = null;
        BlockCipherPadding bp = null;
        if ("NOPadding".equalsIgnoreCase(padding)) {
            if (input.length % b.getBlockSize() != 0) {
                throw new DataLengthException("data not block size aligned: data len:" + input.length + "; block size:" + b.getBlockSize());
            }
            cipher = new BufferedBlockCipher(b);
        } else if ("PKCS5Padding".equalsIgnoreCase(padding)) {
            bp = new PKCS7Padding();
            cipher = new PaddedBufferedBlockCipher(b, bp);
        } else if ("PKCS7Padding".equalsIgnoreCase(padding)) {
            bp = new PKCS7Padding();
            cipher = new PaddedBufferedBlockCipher(b, bp);
        } else {
            if (!"X9.23".equalsIgnoreCase(padding)) throw new ParmErrorException("Cipher Algorithm Padding error:" + mode);
            bp = new X923Padding();
            bp.init(new SecureRandom());
            cipher = new PaddedBufferedBlockCipher(b, bp);
        }
        cipher.init(encrypt, cparms);
        int outBlockSize = cipher.getOutputSize(input.length);
        byte[] outblock = new byte[outBlockSize];
        int outL = 0;
        int outSize = 0;
        outSize = outL = cipher.processBytes(input, 0, input.length, outblock, 0);
        outL = cipher.doFinal(outblock, outL);
        cipher.reset();
        if ((outSize += outL) >= outblock.length) return outblock;
        byte[] rt = new byte[outSize];
        System.arraycopy(outblock, 0, rt, 0, outSize);
        return rt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long streamCipher(String algorithm, String mode, String padding, boolean encrypt, CipherParameters parms, byte[] initVector, InputStream in, OutputStream out) throws Exception {
        CipherParameters hsmParms = Helper.toBCkey(parms);
        BlockCipher b = null;
        if ("AES".equalsIgnoreCase(algorithm)) {
            b = new AESEngine();
        } else if ("DES".equalsIgnoreCase(algorithm)) {
            b = new DESEngine();
        } else if ("DESede".equalsIgnoreCase(algorithm)) {
            b = new DESedeEngine();
        } else {
            if (!"SM4".equalsIgnoreCase(algorithm)) throw new ParmErrorException("Cipher Algorithm Name error:" + algorithm);
            b = new SM4Engine();
        }
        int estimateIVSize = b.getBlockSize();
        CipherParameters cparms = hsmParms;
        if ("CBC".equalsIgnoreCase(mode)) {
            b = new CBCBlockCipher(b);
            if (initVector == null) {
                byte[] tmpIV = new byte[estimateIVSize];
                cparms = new ParametersWithIV(hsmParms, tmpIV);
            } else {
                if (initVector.length != estimateIVSize) throw new ParmErrorException("initialisation vector must be the same length as cipher block size");
                cparms = new ParametersWithIV(hsmParms, initVector);
            }
        } else if (!"ECB".equalsIgnoreCase(mode)) {
            if ("CFB".equalsIgnoreCase(mode)) {
                b = new CFBBlockCipher(b, 8);
                if (initVector != null && initVector.length == estimateIVSize) {
                    cparms = new ParametersWithIV(hsmParms, initVector);
                }
            } else {
                if (!"OFB".equalsIgnoreCase(mode)) throw new ParmErrorException("Cipher Algorithm Mode error:" + mode);
                b = new OFBBlockCipher(b, 8);
                if (initVector != null && initVector.length == estimateIVSize) {
                    cparms = new ParametersWithIV(hsmParms, initVector);
                }
            }
        }
        BufferedBlockCipher cipher = null;
        BlockCipherPadding bp = null;
        if ("NOPadding".equalsIgnoreCase(padding)) {
            if (in.available() % b.getBlockSize() != 0) {
                throw new DataLengthException("input stream data not block size aligned: data len:" + in.available() + "; block size:" + b.getBlockSize());
            }
            cipher = new BufferedBlockCipher(b);
        } else if ("PKCS5Padding".equalsIgnoreCase(padding)) {
            bp = new PKCS7Padding();
            cipher = new PaddedBufferedBlockCipher(b, bp);
        } else if ("PKCS7Padding".equalsIgnoreCase(padding)) {
            bp = new PKCS7Padding();
            cipher = new PaddedBufferedBlockCipher(b, bp);
        } else {
            if (!"X9.23".equalsIgnoreCase(padding)) throw new ParmErrorException("Cipher Algorithm Padding error:" + mode);
            bp = new X923Padding();
            bp.init(new SecureRandom());
            cipher = new PaddedBufferedBlockCipher(b, bp);
        }
        cipher.init(encrypt, cparms);
        Long totoalProcessByte = new Long(0L);
        int inBlockSize = 4096;
        int outBlockSize = cipher.getOutputSize(inBlockSize);
        byte[] inblock = new byte[inBlockSize];
        byte[] outblock = new byte[outBlockSize];
        try {
            int inL = 0;
            int outL = 0;
            while (in.available() > 0) {
                inL = in.read(inblock, 0, inBlockSize);
                outL = cipher.processBytes(inblock, 0, inL, outblock, 0);
                totoalProcessByte = totoalProcessByte + (long)inL;
                if (outL <= 0) continue;
                out.write(outblock, 0, outL);
            }
            outL = cipher.doFinal(outblock, 0);
            if (outL > 0) {
                out.write(outblock, 0, outL);
            }
        }
        catch (Exception e) {
            cipher.reset();
            throw e;
        }
        cipher.reset();
        return totoalProcessByte;
    }

    public static byte[] getCheckValue(String algorithm, CipherParameters parms) throws Exception {
        byte[] input = null;
        if ("SM4".equalsIgnoreCase(algorithm)) {
            input = new byte[16];
        }
        if ("AES".equalsIgnoreCase(algorithm)) {
            input = new byte[16];
        }
        if ("DES".equalsIgnoreCase(algorithm)) {
            input = new byte[8];
        }
        if ("DESede".equalsIgnoreCase(algorithm)) {
            input = new byte[8];
        }
        if (input == null) {
            throw new ParmErrorException("key type error!");
        }
        byte[] checkValue = SymmetricCipher.blockCipher(algorithm, "ECB", "NOPADDING", true, parms, null, input);
        return checkValue;
    }
}

