/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Integer;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.EncodableDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.MD5Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA224Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA384Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.RSAEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithID;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.signers.PSSSigner;
import com.icbc.bcprov.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.icbc.bcprov.org.bouncycastle.crypto.signers.SM2Signer;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.software.utils.Helper;
import com.icbc.hsm.utils.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;

public class Signature {
    private Signature() {
    }

    public static byte[] sign(String algorithm, CipherParameters key, byte[] data) throws Exception {
        CipherParameters hsmKey = Helper.toBCkey(key);
        if ("SM3WITHSM2".equalsIgnoreCase(algorithm)) {
            byte[] id;
            if (IcbcEnvironment.isICBCEnvironment() && key instanceof IcbcAsymmetricKeyParameter && (id = ((IcbcAsymmetricKeyParameter)key).getId()) != null) {
                hsmKey = new ParametersWithID(hsmKey, id);
            }
            return Signature.sm2Sign(hsmKey, data);
        }
        if ("PS256".equalsIgnoreCase(algorithm) || "PS384".equalsIgnoreCase(algorithm) || "PS512".equalsIgnoreCase(algorithm)) {
            if (!(hsmKey instanceof RSAKeyParameters)) {
                // empty if block
            }
            return Signature.pssSign(algorithm, hsmKey, data);
        }
        if (algorithm != null && algorithm.toUpperCase().endsWith("WITHRSA")) {
            if (!(hsmKey instanceof RSAKeyParameters)) {
                // empty if block
            }
            return Signature.rsaSign(algorithm, hsmKey, data);
        }
        throw new ParmErrorException("signature Algorithm Name error:" + algorithm);
    }

    public static boolean verify(String algorithm, CipherParameters key, byte[] data, byte[] signature) throws Exception {
        CipherParameters hsmKey = Helper.toBCkey(key);
        if ("SM3WITHSM2".equalsIgnoreCase(algorithm)) {
            byte[] id;
            if (IcbcEnvironment.isICBCEnvironment() && key instanceof IcbcAsymmetricKeyParameter && (id = ((IcbcAsymmetricKeyParameter)key).getId()) != null) {
                hsmKey = new ParametersWithID(hsmKey, id);
            }
            if (!IcbcEnvironment.isICBCEnvironment() && key instanceof ClearKeyParameter && (id = ((ClearKeyParameter)key).getId()) != null) {
                hsmKey = new ParametersWithID(hsmKey, id);
            }
            return Signature.sm2Verify(hsmKey, data, signature);
        }
        if ("PS256".equalsIgnoreCase(algorithm) || "PS384".equalsIgnoreCase(algorithm) || "PS512".equalsIgnoreCase(algorithm)) {
            if (!(hsmKey instanceof RSAKeyParameters)) {
                // empty if block
            }
            return Signature.pssVerify(algorithm, hsmKey, data, signature);
        }
        if (algorithm != null && algorithm.toUpperCase().endsWith("WITHRSA")) {
            if (!(hsmKey instanceof RSAKeyParameters)) {
                // empty if block
            }
            return Signature.rsaVerify(algorithm, hsmKey, data, signature);
        }
        throw new ParmErrorException("signature Algorithm Name error:" + algorithm);
    }

    private static byte[] rsaSign(String algorithm, CipherParameters key, byte[] data) throws Exception {
        ExtendedDigest di = null;
        if (algorithm == null) {
            throw new ParmErrorException("signature Algorithm Name error:" + algorithm);
        }
        if (algorithm.toUpperCase().startsWith("MD5")) {
            di = new MD5Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA1")) {
            di = new SHA1Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA224")) {
            di = new SHA224Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA256")) {
            di = new SHA256Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA384")) {
            di = new SHA384Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA512")) {
            di = new SHA512Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA3-")) {
            int bits = Integer.parseInt(algorithm.substring("SHA3-".length(), 3));
            di = new SHA3Digest(bits);
        } else if (algorithm.toUpperCase().startsWith("SM3")) {
            di = new SM3Digest();
        } else {
            throw new ParmErrorException("signature Algorithm Name error:" + algorithm);
        }
        RSADigestSigner signer = null;
        signer = new RSADigestSigner(di);
        signer.init(true, key);
        signer.update(data, 0, data.length);
        byte[] sig = signer.generateSignature();
        return sig;
    }

    private static boolean rsaVerify(String algorithm, CipherParameters key, byte[] data, byte[] signature) throws Exception {
        ExtendedDigest di = null;
        if (algorithm == null) {
            throw new ParmErrorException("signature Algorithm Name error:" + algorithm);
        }
        if (algorithm.toUpperCase().startsWith("MD5")) {
            di = new MD5Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA1")) {
            di = new SHA1Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA224")) {
            di = new SHA224Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA256")) {
            di = new SHA256Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA384")) {
            di = new SHA384Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA512")) {
            di = new SHA512Digest();
        } else if (algorithm.toUpperCase().startsWith("SHA3-")) {
            int bits = Integer.parseInt(algorithm.substring("SHA3-".length(), 3));
            di = new SHA3Digest(bits);
        } else if (algorithm.toUpperCase().startsWith("SM3")) {
            di = new SM3Digest();
        } else {
            throw new ParmErrorException("signature Algorithm Name error:" + algorithm);
        }
        RSADigestSigner signer = null;
        signer = new RSADigestSigner(di);
        signer.init(false, key);
        signer.update(data, 0, data.length);
        boolean flag = signer.verifySignature(signature);
        return flag;
    }

    private static byte[] pssSign(String algorithm, CipherParameters key, byte[] data) throws Exception {
        EncodableDigest digest;
        PSSSigner eng = null;
        RSAEngine rsaEngine = new RSAEngine();
        if ("PS256".equalsIgnoreCase(algorithm)) {
            digest = new SHA256Digest();
            eng = new PSSSigner((AsymmetricBlockCipher)rsaEngine, (Digest)((Object)digest), 32);
        } else if ("PS384".equalsIgnoreCase(algorithm)) {
            digest = new SHA384Digest();
            eng = new PSSSigner((AsymmetricBlockCipher)rsaEngine, (Digest)((Object)digest), 32);
        } else if ("PS512".equalsIgnoreCase(algorithm)) {
            digest = new SHA512Digest();
            eng = new PSSSigner((AsymmetricBlockCipher)rsaEngine, (Digest)((Object)digest), 32);
        } else {
            throw new ParmErrorException("signature Algorithm Name error:" + algorithm);
        }
        eng.init(true, key);
        eng.update(data, 0, data.length);
        byte[] s = null;
        s = eng.generateSignature();
        return s;
    }

    private static boolean pssVerify(String algorithm, CipherParameters key, byte[] data, byte[] signature) throws Exception {
        EncodableDigest digest;
        PSSSigner eng = null;
        RSAEngine rsaEngine = new RSAEngine();
        if ("PS256".equalsIgnoreCase(algorithm)) {
            digest = new SHA256Digest();
            eng = new PSSSigner((AsymmetricBlockCipher)rsaEngine, (Digest)((Object)digest), 32);
        } else if ("PS384".equalsIgnoreCase(algorithm)) {
            digest = new SHA384Digest();
            eng = new PSSSigner((AsymmetricBlockCipher)rsaEngine, (Digest)((Object)digest), 32);
        } else if ("PS512".equalsIgnoreCase(algorithm)) {
            digest = new SHA512Digest();
            eng = new PSSSigner((AsymmetricBlockCipher)rsaEngine, (Digest)((Object)digest), 32);
        } else {
            throw new ParmErrorException("signature Algorithm Name error:" + algorithm);
        }
        eng.init(true, key);
        eng.update(data, 0, data.length);
        boolean flag = eng.verifySignature(signature);
        return flag;
    }

    private static byte[] sm2Sign(CipherParameters key, byte[] data) throws Exception {
        byte[] signIn = data;
        byte[] sig = null;
        SM2Signer sms = new SM2Signer();
        do {
            sms.reset();
            sms.init(true, key);
            sms.update(signIn, 0, signIn.length);
            sig = sms.generateSignature();
            if (Signature.validateASN1(sig)) continue;
            System.out.println("improper signature:" + Hex.toHexString(sig) + " regenerate!");
        } while (!Signature.validateASN1(sig));
        return sig;
    }

    private static boolean sm2Verify(CipherParameters key, byte[] data, byte[] signature) {
        byte[] signIn = data;
        byte[] sig = signature;
        boolean flag = false;
        try {
            SM2Signer sms = new SM2Signer();
            sms.init(false, key);
            sms.update(signIn, 0, signIn.length);
            flag = sms.verifySignature(sig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private static boolean validateASN1(byte[] data) {
        boolean flag = true;
        ASN1Sequence seq = null;
        if (data == null) {
            return false;
        }
        try {
            seq = (ASN1Sequence)ASN1Primitive.fromByteArray(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (seq.size() == 2) {
            byte[] s;
            byte[] r = ((ASN1Integer)seq.getObjectAt(0)).getValue().toByteArray();
            if (r.length < 32) {
                flag = false;
            }
            if ((s = ((ASN1Integer)seq.getObjectAt(1)).getValue().toByteArray()).length < 32) {
                flag = false;
            }
        }
        return flag;
    }

    public static byte[] reformatASN1(byte[] data) {
        System.setProperty("com.icbc.bcprov.org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] derData = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(data);
            if (seq.size() == 2) {
                byte[] r = ((ASN1Integer)seq.getObjectAt(0)).getValue().toByteArray();
                byte[] s = ((ASN1Integer)seq.getObjectAt(1)).getValue().toByteArray();
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add(new ASN1Integer(new BigInteger(1, r)));
                v.add(new ASN1Integer(new BigInteger(1, s)));
                derData = new DERSequence(v).getEncoded("DER");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.setProperty("com.icbc.bcprov.org.bouncycastle.asn1.allow_unsafe_integer", "false");
            return null;
        }
        System.setProperty("com.icbc.bcprov.org.bouncycastle.asn1.allow_unsafe_integer", "false");
        return derData;
    }
}

