/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcSymmetricKeyParameter;

public class Rules {
    public static boolean parmCheck(String algParm, CipherParameters key, String apiName) throws Exception {
        if (IcbcEnvironment.isICBCEnvironment() && key instanceof IcbcSymmetricKeyParameter) {
            IcbcSymmetricKeyParameter tempKey = (IcbcSymmetricKeyParameter)key;
            String algorithm = tempKey.getAlgorithm();
            String usage = tempKey.getUsage();
            if ("dek".equalsIgnoreCase(usage) && "cipher".equalsIgnoreCase(apiName)) {
                return algParm != null && algParm.indexOf(algorithm) != -1;
            }
            if ("mak".equalsIgnoreCase(usage) && "mac".equalsIgnoreCase(apiName)) {
                return true;
            }
            if ("pik".equalsIgnoreCase(usage) && "pin".equalsIgnoreCase(apiName)) {
                return true;
            }
            return "hmac".equalsIgnoreCase(usage) && "hmac".equalsIgnoreCase(apiName);
        }
        if (key instanceof ClearKeyParameter) {
            return true;
        }
        if (key instanceof KeyParameter) {
            return true;
        }
        throw new Exception("key type error! " + key.getClass().getName());
    }
}

