/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.PBEParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.MD5Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA224Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA384Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.params.KeyParameter;
import com.icbc.hsm.software.exception.ParmErrorException;

public class PBEkeyGenerate {
    private PBEkeyGenerate() {
    }

    public static byte[] generatePBEKey(String PBEalg, String hashAlg, String usage, int keySize, byte[] password, byte[] salt, int count) throws Exception {
        ExtendedDigest di = null;
        if ("MD5".equalsIgnoreCase(hashAlg)) {
            di = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(hashAlg)) {
            di = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(hashAlg)) {
            di = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(hashAlg)) {
            di = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(hashAlg)) {
            di = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(hashAlg)) {
            di = new SHA512Digest();
        } else if (hashAlg != null && hashAlg.startsWith("SHA3-")) {
            int bits = Integer.parseInt(hashAlg.substring("SHA3-".length()));
            di = new SHA3Digest(bits);
        } else if ("SM3".equalsIgnoreCase(hashAlg)) {
            di = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + hashAlg);
        }
        if (keySize <= 0) {
            throw new ParmErrorException("keySize error:" + keySize);
        }
        PKCS5S2ParametersGenerator generator = null;
        if (!"PBKDF2".equalsIgnoreCase(PBEalg)) {
            throw new ParmErrorException("PBE Algorithm Name error:" + PBEalg);
        }
        generator = new PKCS5S2ParametersGenerator(di);
        generator.init(password, salt, count);
        KeyParameter kp = null;
        kp = "MAC".equalsIgnoreCase(usage) ? (KeyParameter)((PBEParametersGenerator)generator).generateDerivedMacParameters(keySize * 8) : (KeyParameter)((PBEParametersGenerator)generator).generateDerivedParameters(keySize * 8);
        byte[] key = kp.getKey();
        return key;
    }
}

