/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.MD5Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA224Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA384Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.macs.HMac;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.utils.Helper;
import java.io.InputStream;

public class MessageDigest {
    private MessageDigest() {
    }

    public static byte[] digest(String algorithm, byte[] input) throws Exception {
        ExtendedDigest di = null;
        if ("MD5".equalsIgnoreCase(algorithm)) {
            di = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(algorithm)) {
            di = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(algorithm)) {
            di = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(algorithm)) {
            di = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(algorithm)) {
            di = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(algorithm)) {
            di = new SHA512Digest();
        } else if (algorithm != null && algorithm.startsWith("SHA3-")) {
            int bits = Integer.parseInt(algorithm.substring("SHA3-".length()));
            di = new SHA3Digest(bits);
        } else if ("SM3".equalsIgnoreCase(algorithm)) {
            di = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + algorithm);
        }
        int size = di.getDigestSize();
        byte[] result = new byte[size];
        if (input != null) {
            di.update(input, 0, input.length);
        }
        di.doFinal(result, 0);
        di.reset();
        return result;
    }

    public static byte[] streamDigest(String algorithm, InputStream in) throws Exception {
        ExtendedDigest di = null;
        if ("MD5".equalsIgnoreCase(algorithm)) {
            di = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(algorithm)) {
            di = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(algorithm)) {
            di = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(algorithm)) {
            di = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(algorithm)) {
            di = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(algorithm)) {
            di = new SHA512Digest();
        } else if (algorithm != null && algorithm.startsWith("SHA3-")) {
            int bits = Integer.parseInt(algorithm.substring("SHA3-".length()));
            di = new SHA3Digest(bits);
        } else if ("SM3".equalsIgnoreCase(algorithm)) {
            di = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + algorithm);
        }
        int size = di.getDigestSize();
        byte[] result = new byte[size];
        Long totoalProcessByte = new Long(0L);
        int inBlockSize = 4096;
        byte[] inblock = new byte[inBlockSize];
        try {
            int inL;
            while ((inL = in.read(inblock, 0, inBlockSize)) > 0) {
                di.update(inblock, 0, inL);
                totoalProcessByte = totoalProcessByte + (long)inL;
            }
        }
        catch (Exception e) {
            di.reset();
            throw e;
        }
        di.doFinal(result, 0);
        di.reset();
        return result;
    }

    public static byte[] hashingMAC(CipherParameters key, String algorithm, byte[] input) throws Exception {
        CipherParameters hsmKey = Helper.toBCkey(key);
        ExtendedDigest di = null;
        if ("MD5".equalsIgnoreCase(algorithm)) {
            di = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(algorithm)) {
            di = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(algorithm)) {
            di = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(algorithm)) {
            di = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(algorithm)) {
            di = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(algorithm)) {
            di = new SHA512Digest();
        } else if (algorithm != null && algorithm.startsWith("SHA3-")) {
            int bits = Integer.parseInt(algorithm.substring("SHA3-".length()));
            di = new SHA3Digest(bits);
        } else if ("SM3".equalsIgnoreCase(algorithm)) {
            di = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + algorithm);
        }
        HMac hmac = new HMac(di);
        byte[] resBuf = new byte[hmac.getMacSize()];
        hmac.init(hsmKey);
        if (input != null) {
            hmac.update(input, 0, input.length);
        }
        hmac.doFinal(resBuf, 0);
        hmac.reset();
        return resBuf;
    }

    public static byte[] streamHashingMAC(CipherParameters key, String algorithm, InputStream in) throws Exception {
        CipherParameters hsmKey = Helper.toBCkey(key);
        ExtendedDigest di = null;
        if ("MD5".equalsIgnoreCase(algorithm)) {
            di = new MD5Digest();
        } else if ("SHA1".equalsIgnoreCase(algorithm)) {
            di = new SHA1Digest();
        } else if ("SHA224".equalsIgnoreCase(algorithm)) {
            di = new SHA224Digest();
        } else if ("SHA256".equalsIgnoreCase(algorithm)) {
            di = new SHA256Digest();
        } else if ("SHA384".equalsIgnoreCase(algorithm)) {
            di = new SHA384Digest();
        } else if ("SHA512".equalsIgnoreCase(algorithm)) {
            di = new SHA512Digest();
        } else if (algorithm != null && algorithm.startsWith("SHA3-")) {
            int bits = Integer.parseInt(algorithm.substring("SHA3-".length()));
            di = new SHA3Digest(bits);
        } else if ("SM3".equalsIgnoreCase(algorithm)) {
            di = new SM3Digest();
        } else {
            throw new ParmErrorException("Digest Algorithm Name error:" + algorithm);
        }
        HMac hmac = new HMac(di);
        byte[] resBuf = new byte[hmac.getMacSize()];
        hmac.init(hsmKey);
        Long totoalProcessByte = new Long(0L);
        int inBlockSize = 4096;
        byte[] inblock = new byte[inBlockSize];
        try {
            int inL;
            while ((inL = in.read(inblock, 0, inBlockSize)) > 0) {
                hmac.update(inblock, 0, inL);
                totoalProcessByte = totoalProcessByte + (long)inL;
            }
        }
        catch (Exception e) {
            hmac.reset();
            throw e;
        }
        hmac.doFinal(resBuf, 0);
        hmac.reset();
        return resBuf;
    }
}

