/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.BlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.Mac;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.AESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.DESEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.SM4Engine;
import com.icbc.bcprov.org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import com.icbc.bcprov.org.bouncycastle.crypto.macs.ISO9797Alg3Mac;
import com.icbc.bcprov.org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithIV;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.utils.Helper;
import java.io.InputStream;

public class MessageAuthenticate {
    private MessageAuthenticate() {
    }

    public static byte[] authenticate(String algorithm, String padding, CipherParameters parms, byte[] initVector, byte[] input) throws Exception {
        CipherParameters hsmParms = Helper.toBCkey(parms);
        Mac mac = null;
        ISO7816d4Padding bp = null;
        if ("X9.19".equalsIgnoreCase(padding)) {
            bp = null;
        } else if ("zeroPadding".equalsIgnoreCase(padding)) {
            bp = null;
        } else if ("EMV".equalsIgnoreCase(padding)) {
            bp = new ISO7816d4Padding();
        } else if ("PBOC".equalsIgnoreCase(padding)) {
            bp = new ISO7816d4Padding();
        } else if ("ISO7816d4Padding".equalsIgnoreCase(padding)) {
            bp = new ISO7816d4Padding();
        } else {
            throw new ParmErrorException("MAC Cipher Padding Name error:" + padding);
        }
        BlockCipher b = null;
        if ("AES".equalsIgnoreCase(algorithm)) {
            b = new AESEngine();
            mac = new CBCBlockCipherMac(b, b.getBlockSize() * 8, bp);
        } else if ("DES".equalsIgnoreCase(algorithm)) {
            b = new DESEngine();
            mac = new CBCBlockCipherMac(b, b.getBlockSize() * 8, bp);
        } else if ("DESede".equalsIgnoreCase(algorithm)) {
            b = new DESEngine();
            mac = new ISO9797Alg3Mac(b, b.getBlockSize() * 8, bp);
        } else if ("SM4".equalsIgnoreCase(algorithm)) {
            b = new SM4Engine();
            mac = new CBCBlockCipherMac(b, b.getBlockSize() * 8, bp);
        } else {
            throw new ParmErrorException("MAC Cipher Algorithm Name error:" + algorithm);
        }
        CipherParameters cparms = null;
        if (initVector == null) {
            cparms = hsmParms;
        } else if (initVector.length == b.getBlockSize()) {
            cparms = new ParametersWithIV(hsmParms, initVector);
        } else {
            throw new ParmErrorException("initialisation vector must be the same length as cipher block size");
        }
        mac.init(cparms);
        try {
            mac.update(input, 0, input.length);
        }
        catch (Exception e) {
            mac.reset();
            throw e;
        }
        byte[] out = new byte[b.getBlockSize()];
        mac.doFinal(out, 0);
        mac.reset();
        return out;
    }

    public static byte[] streamAuthenticate(String algorithm, String padding, CipherParameters parms, byte[] initVector, InputStream in) throws Exception {
        CipherParameters hsmParms = Helper.toBCkey(parms);
        Mac mac = null;
        ISO7816d4Padding bp = null;
        if ("X9.19".equalsIgnoreCase(padding)) {
            bp = null;
        } else if ("zeroPadding".equalsIgnoreCase(padding)) {
            bp = null;
        } else if ("EMV".equalsIgnoreCase(padding)) {
            bp = new ISO7816d4Padding();
        } else if ("PBOC".equalsIgnoreCase(padding)) {
            bp = new ISO7816d4Padding();
        } else if ("ISO7816d4Padding".equalsIgnoreCase(padding)) {
            bp = new ISO7816d4Padding();
        } else {
            throw new ParmErrorException("MAC Cipher Padding Name error:" + padding);
        }
        BlockCipher b = null;
        if ("AES".equalsIgnoreCase(algorithm)) {
            b = new AESEngine();
            mac = new CBCBlockCipherMac(b, b.getBlockSize() * 8, bp);
        } else if ("DES".equalsIgnoreCase(algorithm)) {
            b = new DESEngine();
            mac = new CBCBlockCipherMac(b, b.getBlockSize() * 8, bp);
        } else if ("DESede".equalsIgnoreCase(algorithm)) {
            b = new DESEngine();
            mac = new ISO9797Alg3Mac(b, b.getBlockSize() * 8, bp);
        } else if ("SM4".equalsIgnoreCase(algorithm)) {
            b = new SM4Engine();
            mac = new CBCBlockCipherMac(b, b.getBlockSize() * 8, bp);
        } else {
            throw new ParmErrorException("MAC Cipher Algorithm Name error:" + algorithm);
        }
        CipherParameters cparms = null;
        if (initVector == null) {
            cparms = hsmParms;
        } else if (initVector.length == b.getBlockSize()) {
            cparms = new ParametersWithIV(hsmParms, initVector);
        } else {
            throw new ParmErrorException("initialisation vector must be the same length as cipher block size");
        }
        mac.init(cparms);
        Long totoalProcessByte = new Long(0L);
        int inBlockSize = 4096;
        byte[] inblock = new byte[inBlockSize];
        try {
            int inL;
            while ((inL = in.read(inblock, 0, inBlockSize)) > 0) {
                mac.update(inblock, 0, inL);
                totoalProcessByte = totoalProcessByte + (long)inL;
            }
        }
        catch (Exception e) {
            mac.reset();
            throw e;
        }
        byte[] out = new byte[b.getBlockSize()];
        mac.doFinal(out, 0);
        mac.reset();
        return out;
    }
}

