/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECConstants;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECCurve;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class Generator {
    public static AsymmetricCipherKeyPair generateSM2KeyPair() throws Exception {
        BigInteger SM2_ECC_P = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
        BigInteger SM2_ECC_A = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
        BigInteger SM2_ECC_B = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
        BigInteger SM2_ECC_N = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
        BigInteger SM2_ECC_H = ECConstants.ONE;
        BigInteger SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        BigInteger SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        ECCurve.Fp curve = new ECCurve.Fp(SM2_ECC_P, SM2_ECC_A, SM2_ECC_B, SM2_ECC_N, SM2_ECC_H);
        ECPoint g = curve.createPoint(SM2_ECC_GX, SM2_ECC_GY);
        ECDomainParameters domainParams = new ECDomainParameters(curve, g, SM2_ECC_N);
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters aKeyGenParams = new ECKeyGenerationParameters(domainParams, new SecureRandom());
        keyPairGenerator.init(aKeyGenParams);
        AsymmetricCipherKeyPair aKp = keyPairGenerator.generateKeyPair();
        return aKp;
    }

    public static AsymmetricCipherKeyPair generateRSAKeyPair(int bitLength) throws Exception {
        RSAKeyPairGenerator pGen = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters genParam = new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), bitLength, 50);
        pGen.init(genParam);
        AsymmetricCipherKeyPair pair = pGen.generateKeyPair();
        return pair;
    }
}

