/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Integer;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DEROctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.InvalidCipherTextException;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.MD5Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA224Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA384Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.encodings.ISO9796d1Encoding;
import com.icbc.bcprov.org.bouncycastle.crypto.encodings.OAEPEncoding;
import com.icbc.bcprov.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.RSAEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.SM2Engine;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.utils.Helper;
import com.icbc.hsm.utils.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.spec.PSource;

public class AsymmetricCipher {
    private AsymmetricCipher() {
    }

    public static byte[] encipher(String algorithm, boolean encrypt, CipherParameters key, byte[] input) throws Exception {
        CipherParameters hsmKey = Helper.toBCkey(key);
        if ("SM2".equalsIgnoreCase(algorithm)) {
            if (encrypt) {
                if (hsmKey instanceof ECPublicKeyParameters) {
                    return AsymmetricCipher.sm2Encryption((ECPublicKeyParameters)hsmKey, input);
                }
                throw new ParmErrorException("Cipher key param error, SM2 ECPublicKeyParameters expected");
            }
            if (hsmKey instanceof ECPrivateKeyParameters) {
                return AsymmetricCipher.sm2Decryption((ECPrivateKeyParameters)hsmKey, input);
            }
            throw new ParmErrorException("Cipher key param error, SM2 ECPrivateKeyParameters expected");
        }
        AsymmetricBlockCipher ab = null;
        ab = AsymmetricCipher.buildRSAEngine(algorithm);
        return AsymmetricCipher.rsaProcess(ab, encrypt, hsmKey, input);
    }

    private static AsymmetricBlockCipher buildRSAEngine(String algorithmPad) {
        AsymmetricBlockCipher ab = null;
        RSAEngine baseEngine = new RSAEngine();
        ExtendedDigest digest = null;
        if ("NOPADDING".equalsIgnoreCase(algorithmPad)) {
            ab = new RSAEngine();
        } else if ("PKCS1PADDING".equalsIgnoreCase(algorithmPad)) {
            ab = new PKCS1Encoding(baseEngine);
        } else if ("ISO9796-1PADDING".equalsIgnoreCase(algorithmPad)) {
            ab = new ISO9796d1Encoding(baseEngine);
        } else if ("OAEPPadding".equalsIgnoreCase(algorithmPad)) {
            ab = new OAEPEncoding(baseEngine);
        } else if ("OAEPWITHMD5ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new MD5Digest();
            ab = new OAEPEncoding(baseEngine, digest, null);
        } else if ("OAEPWITHSHA1ANDMGF1PADDING".equalsIgnoreCase(algorithmPad) || "OAEPWITHSHA-1ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new SHA1Digest();
            ab = new OAEPEncoding(baseEngine, digest, null);
        } else if ("OAEPWITHSHA224ANDMGF1PADDING".equalsIgnoreCase(algorithmPad) || "OAEPWITHSHA-224ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new SHA224Digest();
            ab = new OAEPEncoding(baseEngine, digest, null);
        } else if ("OAEPWITHSHA256ANDMGF1PADDING".equalsIgnoreCase(algorithmPad) || "OAEPWITHSHA-256ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new SHA256Digest();
            ab = new OAEPEncoding(baseEngine, digest, null);
        } else if ("OAEPWITHSHA384ANDMGF1PADDING".equalsIgnoreCase(algorithmPad) || "OAEPWITHSHA-384ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new SHA384Digest();
            ab = new OAEPEncoding(baseEngine, digest, null);
        } else if ("OAEPWITHSHA512ANDMGF1PADDING".equalsIgnoreCase(algorithmPad) || "OAEPWITHSHA-512ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new SHA512Digest();
            ab = new OAEPEncoding(new RSAEngine(), digest, null);
        } else if ("OAEPWITHSHA3-224ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new SHA3Digest(224);
            ab = new OAEPEncoding(baseEngine, digest, PSource.PSpecified.DEFAULT.getValue());
        } else if ("OAEPWITHSHA3-256ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new SHA3Digest(256);
            ab = new OAEPEncoding(baseEngine, digest, PSource.PSpecified.DEFAULT.getValue());
        } else if ("OAEPWITHSHA3-384ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new SHA3Digest(384);
            ab = new OAEPEncoding(baseEngine, digest, PSource.PSpecified.DEFAULT.getValue());
        } else if ("OAEPWITHSHA3-512ANDMGF1PADDING".equalsIgnoreCase(algorithmPad)) {
            digest = new SHA3Digest(512);
            ab = new OAEPEncoding(baseEngine, digest, PSource.PSpecified.DEFAULT.getValue());
        }
        return ab;
    }

    private static byte[] rsaProcess(AsymmetricBlockCipher ab, boolean encrypt, CipherParameters parms, byte[] input) throws ParmErrorException, InvalidCipherTextException, Exception {
        ab.init(encrypt, parms);
        if (encrypt && (ab instanceof RSAEngine ? input.length > ab.getInputBlockSize() + 1 : input.length > ab.getInputBlockSize())) {
            throw new ParmErrorException("Cipher input exceed max length:" + ab.getInputBlockSize());
        }
        byte[] out = ab.processBlock(input, 0, input.length);
        return out;
    }

    private static byte[] sm2Encryption(CipherParameters ep, byte[] data) throws Exception {
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        ParametersWithRandom pr = new ParametersWithRandom(ep, new SecureRandom());
        byte[] der = null;
        int count = 0;
        while (count++ < 5 && der == null) {
            sm2Engine.init(true, pr);
            byte[] enc = sm2Engine.processBlock(data, 0, data.length);
            der = AsymmetricCipher.encode(enc);
        }
        return der;
    }

    private static byte[] sm2Decryption(CipherParameters epp, byte[] data) throws Exception {
        byte[] dec = AsymmetricCipher.decode(data);
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(false, epp);
        byte[] out = sm2Engine.processBlock(dec, 0, dec.length);
        return out;
    }

    private static byte[] encode(byte[] cipherData) throws Exception {
        byte[] X = Arrays.copyOfRange(cipherData, 1, 33);
        byte[] Y = Arrays.copyOfRange(cipherData, 33, 65);
        byte[] C3 = Arrays.copyOfRange(cipherData, 65, 97);
        byte[] C2 = Arrays.copyOfRange(cipherData, 97, cipherData.length);
        String Xhead = Hex.toHexString(X).substring(0, 3);
        String Yhead = Hex.toHexString(Y).substring(0, 3);
        if (Integer.parseInt(Xhead, 16) < 8 || Integer.parseInt(Yhead, 16) < 8) {
            return null;
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(new BigInteger(1, X)));
        v.add(new ASN1Integer(new BigInteger(1, Y)));
        v.add(new DEROctetString(C3));
        v.add(new DEROctetString(C2));
        byte[] derData = new DERSequence(v).getEncoded("DER");
        return derData;
    }

    private static byte[] decode(byte[] cipherData) throws Exception {
        ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(cipherData);
        if (seq.size() == 4) {
            byte[] Y;
            byte[] X = ((ASN1Integer)seq.getObjectAt(0)).getValue().toByteArray();
            if (X.length == 33) {
                X = Arrays.copyOfRange(X, 1, X.length);
            }
            if ((Y = ((ASN1Integer)seq.getObjectAt(1)).getValue().toByteArray()).length == 33) {
                Y = Arrays.copyOfRange(Y, 1, Y.length);
            }
            byte[] C3 = ((DEROctetString)seq.getObjectAt(2)).getOctets();
            byte[] C2 = ((DEROctetString)seq.getObjectAt(3)).getOctets();
            byte[] bcFormat = new byte[1 + X.length + Y.length + C3.length + C2.length];
            System.arraycopy(Hex.decode("04"), 0, bcFormat, 0, 1);
            System.arraycopy(X, 0, bcFormat, 1, X.length);
            System.arraycopy(Y, 0, bcFormat, 1 + X.length, Y.length);
            System.arraycopy(C3, 0, bcFormat, 1 + X.length + Y.length, C3.length);
            System.arraycopy(C2, 0, bcFormat, 1 + X.length + Y.length + C3.length, C2.length);
            return bcFormat;
        }
        throw new Exception("encrypted data error!");
    }
}

