/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import java.util.Arrays;

public class Signature {
    private static final String apiName = "signature";
    private String signatureAlgorithm = null;
    private byte[] id = null;

    private Signature(String signatureAlgorithm, byte[] id) {
        this.signatureAlgorithm = signatureAlgorithm;
        if (id != null) {
            this.id = Arrays.copyOf(id, id.length);
        }
    }

    public static Signature getInstance(String signatureAlgorithm) {
        Signature ds = new Signature(signatureAlgorithm, null);
        return ds;
    }

    public static Signature getInstance(byte[] id) {
        Signature ds = new Signature("SM3withSM2", id);
        return ds;
    }

    public byte[] sign(HsmKeyParameter key, byte[] data) throws Exception {
        if (this.id != null) {
            this.setIDtoKey(key);
        }
        byte[] signature = com.icbc.hsm.software.basic.Signature.sign(this.signatureAlgorithm, key, data);
        return signature;
    }

    public boolean verify(HsmKeyParameter key, byte[] data, byte[] signature) throws Exception {
        if (this.id != null) {
            this.setIDtoKey(key);
        }
        boolean flag = com.icbc.hsm.software.basic.Signature.verify(this.signatureAlgorithm, key, data, signature);
        return flag;
    }

    private void setIDtoKey(HsmKeyParameter key) {
        Object tempKey;
        if (IcbcEnvironment.isICBCEnvironment() && key instanceof IcbcAsymmetricKeyParameter) {
            tempKey = (IcbcAsymmetricKeyParameter)key;
            tempKey.setId(this.id);
        }
        if (key instanceof ClearKeyParameter) {
            tempKey = (ClearKeyParameter)key;
            ((ClearKeyParameter)tempKey).setId(this.id);
        }
    }

    public String getParameter() {
        StringBuffer sb = new StringBuffer();
        sb.append("signatureAlgorithm: ").append(this.signatureAlgorithm);
        return sb.toString();
    }
}

