/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import com.icbc.hsm.software.basic.AsymmetricCipher;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.PBEkeyGenerate;
import com.icbc.hsm.software.basic.Rules;
import com.icbc.hsm.software.basic.SymmetricCipher;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.software.parms.icbc.TempKeyBuilder;
import com.icbc.hsm.utils.Util;
import com.icbc.hsm.utils.encoders.Base64;
import com.icbc.hsm.utils.encoders.Hex;
import java.security.SecureRandom;

public class Pinblock {
    private static final String apiName = "pin";
    private String pinAlgorithm = null;

    private Pinblock(String pinAlgorithm) {
        this.pinAlgorithm = pinAlgorithm;
    }

    public static Pinblock getInstance(String pinAlgorithm) {
        Pinblock p = new Pinblock(pinAlgorithm);
        return p;
    }

    String encipherPin(String publicKey, String pin, String pan) throws Exception {
        byte[] pinblock = Pinblock.buildCUPPinblock(pin, pan);
        SecureRandom random = new SecureRandom();
        byte[] pwd = new byte[20];
        random.nextBytes(pwd);
        byte[] salt = new byte[32];
        random.nextBytes(salt);
        byte[] randomKey = PBEkeyGenerate.generatePBEKey("PBKDF2", "SM3", null, 16, pwd, salt, 16);
        ClearKeyParameter key = null;
        key = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"SM4", (boolean)false, (byte[])randomKey) : ClearKeyParameter.getInstance("SM4", false, randomKey);
        ClearKeyParameter pub = null;
        pub = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"SM2", (boolean)false, (byte[])Hex.decode(publicKey)) : ClearKeyParameter.getInstance("SM2", false, Hex.decode(publicKey));
        byte[] encryptedKey = AsymmetricCipher.encipher("SM2", true, pub, randomKey);
        Arrays.fill(randomKey, (byte)0);
        byte[] encryptedPinblock = SymmetricCipher.blockCipher("SM4", "ECB", "NOPadding", true, key, null, pinblock);
        Arrays.fill(pinblock, (byte)0);
        StringBuilder sb = new StringBuilder();
        sb.append("SM2#");
        sb.append(Base64.toBase64String(Hex.decode(publicKey))).append("#");
        sb.append(Base64.toBase64String(encryptedKey)).append("#");
        sb.append(Hex.toHexString(encryptedPinblock)).append("#");
        sb.append(pan);
        return sb.toString();
    }

    public String encipherPin(HsmKeyParameter key, String pin, String pan) throws Exception {
        String algorithm = null;
        if ("ISO".equalsIgnoreCase(this.pinAlgorithm)) {
            algorithm = "DES";
        } else if ("CUP".equalsIgnoreCase(this.pinAlgorithm)) {
            algorithm = "SM4";
        } else if ("ICBC".equalsIgnoreCase(this.pinAlgorithm)) {
            algorithm = "SM4";
        }
        if (IcbcEnvironment.isICBCEnvironment() && key instanceof IcbcAsymmetricKeyParameter) {
            IcbcAsymmetricKeyParameter tempKey = (IcbcAsymmetricKeyParameter)key;
            if ("SM2public".equalsIgnoreCase(tempKey.getKeyType())) {
                String publicKey = tempKey.getPublicKey();
                return this.encipherPin(publicKey, pin, pan);
            }
            throw new ParmErrorException("key type error!");
        }
        if (key instanceof ClearKeyParameter) {
            ClearKeyParameter tempKey = (ClearKeyParameter)key;
            if ("SM2public".equalsIgnoreCase(tempKey.getKeyType())) {
                String publicKey = tempKey.getPublicKey();
                return this.encipherPin(publicKey, pin, pan);
            }
            throw new ParmErrorException("key type error!");
        }
        if (!Rules.parmCheck(algorithm, key, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        String alg = key.getAlgorithm();
        byte[] pinblock = null;
        byte[] encryptedPinblock = null;
        if ("SM4".equalsIgnoreCase(alg)) {
            pinblock = Pinblock.buildCUPPinblock(pin, pan);
            encryptedPinblock = SymmetricCipher.blockCipher("SM4", "ECB", "NOPadding", true, key, null, pinblock);
            Arrays.fill(pinblock, (byte)0);
        } else if ("DESede".equalsIgnoreCase(alg)) {
            pinblock = Pinblock.buildISOPinblock(pin, pan);
            encryptedPinblock = SymmetricCipher.blockCipher("DESede", "ECB", "NOPadding", true, key, null, pinblock);
            Arrays.fill(pinblock, (byte)0);
        } else if ("DES".equalsIgnoreCase(alg)) {
            pinblock = Pinblock.buildISOPinblock(pin, pan);
            encryptedPinblock = SymmetricCipher.blockCipher("DES", "ECB", "NOPadding", true, key, null, pinblock);
            Arrays.fill(pinblock, (byte)0);
        }
        return Base64.toBase64String(encryptedPinblock);
    }

    private static byte[] buildCUPPinblock(String pin, String pan) throws Exception {
        if (pin == null || !pin.matches("\\p{Digit}{4,12}")) {
            throw new Exception("pin error!");
        }
        if (pan != null && !pan.matches("\\p{Digit}+")) {
            throw new Exception("pan error!");
        }
        String pinData = ("0" + String.format("%1$01X", pin.length()) + pin + "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF").substring(0, 32);
        String panData = null;
        if (pan == null) {
            panData = "00000000000000000000000000000000";
        } else if (pan.length() == 12) {
            panData = "0000" + "0000000000000000" + pan;
        } else if (pan.length() > 12) {
            pan = pan.substring(pan.length() - 1 - 12, pan.length() - 1);
            panData = "0000" + "0000000000000000" + pan;
        } else {
            throw new Exception("pan data error!");
        }
        byte[] pinBlock = Util.Xor(Hex.decode(pinData), Hex.decode(panData));
        return pinBlock;
    }

    private static byte[] buildISOPinblock(String pin, String pan) throws Exception {
        if (pin == null || !pin.matches("\\p{Digit}{4,12}")) {
            throw new Exception("pin error!");
        }
        if (pan == null || !pan.matches("\\p{Digit}{12,}")) {
            throw new Exception("pan error!");
        }
        String pinData = ("0" + String.format("%1$01X", pin.length()) + pin + "FFFFFFFFFF").substring(0, 16);
        String panData = null;
        if (pan.length() == 12) {
            panData = "0000" + pan;
        } else if (pan.length() > 12) {
            pan = pan.substring(pan.length() - 1 - 12, pan.length() - 1);
            panData = "0000" + pan;
        }
        byte[] pinBlock = Util.Xor(Hex.decode(pinData), Hex.decode(panData));
        return pinBlock;
    }
}

