/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.MessageAuthenticate;
import com.icbc.hsm.software.basic.Rules;
import com.icbc.hsm.software.exception.ParmErrorException;
import java.util.Arrays;

public class Mac {
    private static final String apiName = "mac";
    private String macAlgorithm = null;
    private byte[] iv = null;

    private Mac(String macAlgorithm, byte[] iv) {
        this.macAlgorithm = macAlgorithm;
        if (iv != null) {
            this.iv = Arrays.copyOfRange(iv, 0, iv.length);
        }
    }

    public static Mac getInstance(String macAlgorithm) {
        return Mac.getInstance(macAlgorithm, null);
    }

    public static Mac getInstance(String macAlgorithm, byte[] iv) {
        Mac c = new Mac(macAlgorithm, iv);
        return c;
    }

    public byte[] generate(HsmKeyParameter key, byte[] data) throws Exception {
        if (!Rules.parmCheck(this.macAlgorithm, key, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        byte[] mac = MessageAuthenticate.authenticate(key.getAlgorithm(), this.macAlgorithm, key, this.iv, data);
        return mac;
    }

    public boolean verify(HsmKeyParameter key, byte[] data, byte[] mac) throws Exception {
        if (!Rules.parmCheck(this.macAlgorithm, key, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        byte[] macOut = MessageAuthenticate.authenticate(key.getAlgorithm(), this.macAlgorithm, key, this.iv, data);
        return Arrays.equals(mac, macOut);
    }

    public String getParameter() {
        StringBuffer sb = new StringBuffer();
        sb.append("macAlgorithm: ").append(this.macAlgorithm);
        return sb.toString();
    }
}

