/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.MessageDigest;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.utils.encoders.Hex;

public class Hash {
    private static final String apiName = "hash";
    private String hashAlgorithm;

    private Hash(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public static Hash getInstance(String hashAlgorithm) {
        Hash hash = new Hash(hashAlgorithm);
        return hash;
    }

    public byte[] GenerateHash(byte[] srcData) throws Exception {
        String algorithm = this.hashAlgorithm;
        byte[] hash = MessageDigest.digest(algorithm, srcData);
        return hash;
    }

    public byte[] GenerateHash(byte[] srcData, byte[] id, String key) throws Exception {
        String algorithm = this.hashAlgorithm;
        byte[] hash = null;
        String idString = null;
        String xy = null;
        idString = id == null ? "31323334353637383132333435363738" : Hex.toHexString(id);
        if (key.length() != 130 || !key.startsWith("04")) {
            throw new Exception("key data error");
        }
        xy = key.substring(2);
        String a = "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC";
        String b = "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93";
        String x_G = "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7";
        String y_G = "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0";
        String ZString = idString + a + b + x_G + y_G + xy;
        String ENTL = String.format("%1$04x", idString.length() * 4);
        ZString = ENTL + ZString;
        hash = MessageDigest.digest(algorithm, Hex.decode(ZString));
        byte[] temp = new byte[hash.length + srcData.length];
        System.arraycopy(hash, 0, temp, 0, hash.length);
        System.arraycopy(srcData, 0, temp, hash.length, srcData.length);
        hash = MessageDigest.digest(algorithm, temp);
        return hash;
    }

    public byte[] GenerateHash(byte[] srcData, byte[] id, HsmKeyParameter key) throws Exception {
        ECPoint pt;
        ECPrivateKeyParameters p;
        CipherParameters cp;
        ClearKeyParameter tempKey;
        String publicKey = null;
        if (key instanceof ClearKeyParameter) {
            tempKey = (ClearKeyParameter)key;
            if ("SM2private".equalsIgnoreCase(tempKey.getKeyType())) {
                cp = tempKey.getBCkey();
                if (cp instanceof ECPrivateKeyParameters) {
                    p = (ECPrivateKeyParameters)cp;
                    pt = new FixedPointCombMultiplier().multiply(p.getParameters().getG(), p.getD()).normalize();
                    publicKey = "04" + String.format("%1$064x", pt.getAffineXCoord().toBigInteger()) + String.format("%1$064x", pt.getAffineYCoord().toBigInteger());
                }
            } else if ("SM2public".equalsIgnoreCase(tempKey.getKeyType())) {
                publicKey = tempKey.getPublicKey();
            }
        }
        if (IcbcEnvironment.isICBCEnvironment() && key instanceof IcbcAsymmetricKeyParameter) {
            tempKey = (IcbcAsymmetricKeyParameter)key;
            if ("SM2private".equalsIgnoreCase(tempKey.getKeyType())) {
                cp = tempKey.getBCkey();
                if (cp instanceof ECPrivateKeyParameters) {
                    p = (ECPrivateKeyParameters)cp;
                    pt = new FixedPointCombMultiplier().multiply(p.getParameters().getG(), p.getD()).normalize();
                    publicKey = "04" + String.format("%1$064x", pt.getAffineXCoord().toBigInteger()) + String.format("%1$064x", pt.getAffineYCoord().toBigInteger());
                }
            } else if ("SM2public".equalsIgnoreCase(tempKey.getKeyType())) {
                publicKey = tempKey.getPublicKey();
            }
        }
        if (publicKey != null) {
            return this.GenerateHash(srcData, id, publicKey);
        }
        throw new Exception("key type error!");
    }

    public String getParameter() {
        StringBuffer sb = new StringBuffer();
        sb.append("hashAlgorithm: ").append(this.hashAlgorithm);
        return sb.toString();
    }
}

