/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.hsm.software.basic.AsymmetricCipher;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.PBEkeyGenerate;
import com.icbc.hsm.software.basic.Rules;
import com.icbc.hsm.software.basic.SymmetricCipher;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.TempKeyBuilder;
import com.icbc.hsm.utils.encoders.Hex;
import java.security.SecureRandom;

public class Cipher {
    private static final String apiName = "cipher";
    private String algorithm = null;
    private String chainMode = null;
    private String padMode = null;
    private byte[] iv = null;

    private Cipher(String algorithm, String chainMode, String padMode, byte[] iv) {
        this.algorithm = algorithm;
        this.chainMode = chainMode;
        this.padMode = padMode;
        if (iv != null) {
            this.iv = new byte[iv.length];
            System.arraycopy(iv, 0, this.iv, 0, iv.length);
        }
    }

    public static Cipher getInstance(String algorithm) {
        if ("SM2".equalsIgnoreCase(algorithm) || "RSA".equalsIgnoreCase(algorithm) || "RSA-OAEP".equalsIgnoreCase(algorithm)) {
            return new Cipher(algorithm, null, null, null);
        }
        return Cipher.getInstance(algorithm, "CBC", "PKCS5PADDING", null);
    }

    public static Cipher getInstance(String algorithm, String chainMode, String padMode) {
        return Cipher.getInstance(algorithm, chainMode, padMode, null);
    }

    public static Cipher getInstance(String algorithm, String chainMode, String padMode, byte[] iv) {
        Cipher c = new Cipher(algorithm, chainMode, padMode, iv);
        return c;
    }

    public byte[] encipher(HsmKeyParameter key, byte[] data) throws Exception {
        return this.cipher(key, data, true);
    }

    public byte[] decipher(HsmKeyParameter key, byte[] data) throws Exception {
        return this.cipher(key, data, false);
    }

    private byte[] cipher(HsmKeyParameter key, byte[] data, boolean flag) throws Exception {
        if (!Rules.parmCheck(this.algorithm, key, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        byte[] encryptedData = SymmetricCipher.blockCipher(this.algorithm, this.chainMode, this.padMode, flag, key, this.iv, data);
        return encryptedData;
    }

    public SealedPackage seal(HsmKeyParameter key, byte[] data, String asymmetricCipherAlgorithm) throws Exception {
        int size = 0;
        if ("DES".equalsIgnoreCase(this.algorithm)) {
            size = 8;
        } else if ("DESede".equalsIgnoreCase(this.algorithm)) {
            size = 24;
        } else if ("AES".equalsIgnoreCase(this.algorithm)) {
            size = 32;
        } else if ("SM4".equalsIgnoreCase(this.algorithm)) {
            size = 16;
        }
        byte[] random = this.generateRandom(size);
        byte[] encryptedKey = null;
        if ("RSA".equalsIgnoreCase(key.getAlgorithm())) {
            if (asymmetricCipherAlgorithm == null) {
                asymmetricCipherAlgorithm = "PKCS1PADDING";
            }
            encryptedKey = AsymmetricCipher.encipher(asymmetricCipherAlgorithm, true, key, random);
        }
        if ("SM2".equalsIgnoreCase(key.getAlgorithm())) {
            if (asymmetricCipherAlgorithm == null) {
                asymmetricCipherAlgorithm = "SM2";
            }
            encryptedKey = AsymmetricCipher.encipher(asymmetricCipherAlgorithm, true, key, random);
        }
        ClearKeyParameter clearKey = null;
        clearKey = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)this.algorithm, (boolean)false, (byte[])random) : ClearKeyParameter.getInstance(this.algorithm, false, random);
        byte[] encryptedData = SymmetricCipher.blockCipher(this.algorithm, this.chainMode, this.padMode, true, clearKey, this.iv, data);
        String cipherParameters = asymmetricCipherAlgorithm + ";" + this.algorithm + "/" + this.chainMode + "/" + this.padMode;
        return new SealedPackage(encryptedKey, encryptedData, cipherParameters);
    }

    public byte[] unseal(HsmKeyParameter key, byte[] encryptedKey, byte[] encryptedData, String asymmetricCipherAlgorithm) throws Exception {
        byte[] clear = null;
        clear = AsymmetricCipher.encipher(asymmetricCipherAlgorithm, false, key, encryptedKey);
        ClearKeyParameter clearKey = null;
        clearKey = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)this.algorithm, (boolean)false, (byte[])clear) : ClearKeyParameter.getInstance(this.algorithm, false, clear);
        byte[] decryptedData = this.cipher(clearKey, encryptedData, false);
        return decryptedData;
    }

    private byte[] generateRandom(int size) throws Exception {
        SecureRandom random = new SecureRandom();
        byte[] pwd = new byte[20];
        random.nextBytes(pwd);
        byte[] salt = new byte[32];
        random.nextBytes(salt);
        byte[] randomKey = PBEkeyGenerate.generatePBEKey("PBKDF2", "SM3", null, size, pwd, salt, 16);
        return randomKey;
    }

    public String getParameter() {
        StringBuffer sb = new StringBuffer();
        sb.append("algorithm: ").append(this.algorithm).append("; ");
        sb.append("chainMode: ").append(this.chainMode).append("; ");
        sb.append("padMode: ").append(this.padMode).append("; ");
        sb.append("iv: ").append(this.iv == null ? "null" : Hex.toHexString(this.iv));
        return sb.toString();
    }

    public class SealedPackage {
        private byte[] encryptedKey = null;
        private byte[] encryptedData = null;
        private String cipherParameters = null;

        SealedPackage(byte[] encryptedKey, byte[] encryptedData, String cipherParameters) {
            this.encryptedKey = encryptedKey;
            this.encryptedData = encryptedData;
            this.cipherParameters = cipherParameters;
        }

        public byte[] getEncryptedKey() {
            return this.encryptedKey;
        }

        public byte[] getEncryptedData() {
            return this.encryptedData;
        }

        public String getCipherParameters() {
            return this.cipherParameters;
        }
    }
}

