/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.xmss;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.icbc.bcprov.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHAKEDigest;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTKeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPrivateKey;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPublicKey;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.spec.XMSSMTParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSMTKeyPairGeneratorSpi
extends KeyPairGenerator {
    private XMSSMTKeyGenerationParameters param;
    private XMSSMTKeyPairGenerator engine = new XMSSMTKeyPairGenerator();
    private ASN1ObjectIdentifier treeDigest;
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public XMSSMTKeyPairGeneratorSpi() {
        super("XMSSMT");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof XMSSMTParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a XMSSMTParameterSpec");
        }
        XMSSMTParameterSpec xmssParams = (XMSSMTParameterSpec)params;
        if (xmssParams.getTreeDigest().equals("SHA256")) {
            this.treeDigest = NISTObjectIdentifiers.id_sha256;
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xmssParams.getHeight(), xmssParams.getLayers(), new SHA256Digest()), random);
        } else if (xmssParams.getTreeDigest().equals("SHA512")) {
            this.treeDigest = NISTObjectIdentifiers.id_sha512;
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xmssParams.getHeight(), xmssParams.getLayers(), new SHA512Digest()), random);
        } else if (xmssParams.getTreeDigest().equals("SHAKE128")) {
            this.treeDigest = NISTObjectIdentifiers.id_shake128;
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xmssParams.getHeight(), xmssParams.getLayers(), new SHAKEDigest(128)), random);
        } else if (xmssParams.getTreeDigest().equals("SHAKE256")) {
            this.treeDigest = NISTObjectIdentifiers.id_shake256;
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xmssParams.getHeight(), xmssParams.getLayers(), new SHAKEDigest(256)), random);
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(10, 20, new SHA512Digest()), this.random);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        XMSSMTPublicKeyParameters pub = (XMSSMTPublicKeyParameters)pair.getPublic();
        XMSSMTPrivateKeyParameters priv = (XMSSMTPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCXMSSMTPublicKey(this.treeDigest, pub), new BCXMSSMTPrivateKey(this.treeDigest, priv));
    }
}

