/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.xmss;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.interfaces.XMSSKey;
import com.icbc.bcprov.org.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

public class BCXMSSPublicKey
implements PublicKey,
XMSSKey {
    private static final long serialVersionUID = -5617456225328969766L;
    private transient XMSSPublicKeyParameters keyParams;
    private transient ASN1ObjectIdentifier treeDigest;

    public BCXMSSPublicKey(ASN1ObjectIdentifier treeDigest, XMSSPublicKeyParameters keyParams) {
        this.treeDigest = treeDigest;
        this.keyParams = keyParams;
    }

    public BCXMSSPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        XMSSKeyParams keyParams = XMSSKeyParams.getInstance(keyInfo.getAlgorithm().getParameters());
        this.treeDigest = keyParams.getTreeDigest().getAlgorithm();
        this.keyParams = (XMSSPublicKeyParameters)PublicKeyFactory.createKey(keyInfo);
    }

    @Override
    public final String getAlgorithm() {
        return "XMSS";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo pki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCXMSSPublicKey) {
            BCXMSSPublicKey otherKey = (BCXMSSPublicKey)o;
            return this.treeDigest.equals(otherKey.treeDigest) && Arrays.areEqual(this.keyParams.toByteArray(), otherKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }

    @Override
    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    @Override
    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName(this.treeDigest);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

